﻿package com.terry.engine {
	import flash.display.*;
	import flash.geom.*;
  import flash.events.*;
  import flash.net.*;
	
	public class help {
		public static function init():void {
			for(var i:int=0; i<360; i++){
				sine[i]=Math.sin((i*6.283)/64);
				cosine[i]=Math.cos((i*6.283)/64);
			}
			
			glow = 0;
			glowdir = 0;
			fastglow = 0;
			fastglowdir = 0;
			slowsine = 0;
		}
		
		public static function RGB(red:Number,green:Number,blue:Number):Number {
			return (blue | (green << 8) | (red << 16));
		}
		
		public static function wrap(t:int, start:int, end:int):int {
			while (t < start) t += (end - start);
			return (t % (end - start)) + start;
		}
		
		public static function number(t:int):String {
			switch(t) {
			  case 0: return "Zero"; break;
				case 1: return "One"; break;
				case 2: return "Two"; break;
				case 3: return "Three"; break;
				case 4: return "Four"; break;
				case 5: return "Five"; break;
				case 6: return "Six"; break;
				case 7: return "Seven"; break;
				case 8: return "Eight"; break;
				case 9: return "Nine"; break;
				case 10: return "Ten"; break;
				case 11: return "Eleven"; break;
				case 12: return "Twelve"; break;
				case 13: return "Thirteen"; break;
				case 14: return "Fourteen"; break;
				case 15: return "Fifteen"; break;
				case 16: return "Sixteen"; break;
				case 17: return "Seventeen"; break;
				case 18: return "Eighteen"; break;
				case 19: return "Nineteen"; break;
				case 20: return "Twenty"; break;
				case 21: return "Twenty One"; break;
			}
			return "Some";
		}
		
		public static function removeObject(obj:Object, arr:Array):void{
			var i:String;
			for (i in arr){
				if (arr[i] == obj){
					arr.splice(i,1)
					break;
				}
			}
		}
		
		public static function updateglow():void {
			slowsine++;
			if (slowsine >= 64) slowsine = 0;
			
		  if (glowdir == 0) {
			  glow+=1; 
				if (glow >= 63) glowdir = 1;
			}else {
			  glow-=1;
				if (glow < 1) glowdir = 0;
			}
			
			if (fastglowdir == 0) {
			  fastglow+=2; 
				if (fastglow >= 50) {
					fastglow = 50;
					fastglowdir = 1;
				}
			}else {
			  fastglow-=2;
				if (fastglow < 0) {
					fastglow = 0;
					fastglowdir = 0;
				}
			}
		}
		
		public static function inbox(xc:int, yc:int, x1:int, y1:int, x2:int, y2:int):Boolean {
			if (xc >= x1 && xc <= x2) {
				if (yc >= y1 && yc <= y2) {
					return true;
				}
			}
			return false;
		}
		
		public static function inboxw(xc:int, yc:int, x1:int, y1:int, x2:int, y2:int):Boolean {
			if (xc >= x1 && xc <= x1+x2) {
				if (yc >= y1 && yc <= y1+y2) {
					return true;
				}
			}
			return false;
		}
		
		
		public static function twodigits(t:int):String {
			if (t < 10) return "0" + String(t);
			return String(t);
		}
		
		public static function threedigits(t:int):String {
			if (t < 10) return "00" + String(t);
			if (t < 100) return "0" + String(t);
			return String(t);
		}
		
		public static function thousand(t:int):String {
			if (t < 1000) {
			  return "$"+String(t);	
			}else if (t < 1000000) {
				return "$"+String((t - (t % 1000)) / 1000) + "," + threedigits(t % 1000);
			}else {
				var temp:int;
				temp = (t - (t % 1000)) / 1000;
				return "$" + String((temp - (temp % 1000)) / 1000) + "," 
				           + threedigits(temp % 1000) + "," + threedigits(t % 1000);
			}
		}
		
		public static function Instr(s:String,c:String,start:int=1):int{
  		return (s.indexOf(c,start-1)+1);
		}
		
		public static function Mid(s:String,start:int=0,length:int=1):String{
		  return s.substr(start,length);
		}
		
		public static function Left(s:String,length:int=1):String{
		  return s.substr(0,length);
		}
		
		public static function Right(s:String,length:int=1):String{
		  return s.substr(s.length-length,length);
		} 
		
		public static function getlastbranch(n:String, ch:String):String {
			//Given a string n, return everything after the LAST occurance of the "ch" character
			while (Instr(n, ch)) n = getbranch(n, ch);
			return n;
		}
		
		public static function getroot(n:String, ch:String):String {
			//Given a string n, return everything before the first occurance of the "ch" character
			for (var i:int = 0; i < n.length; i++) {
				if (Mid(n, i, 1) == ch) {
					return Mid(n, 0, i);
				}
			}
			return n;
		}
		
		public static function getbranch(n:String, ch:String):String {
			//Given a string n, return everything after the first occurance of the "ch" character
			for (var i:int = 0; i < n.length; i++) {
				if (Mid(n, i, 1) == ch) {
					return Mid(n, i + 1, n.length - i - 1);
				}
			}
			return n;
		}
		
		public static function getbrackets(n:String):String {
			//Given a string n, return everything between the first and the last bracket
			while (Mid(n, 0, 1) != "(" && n.length > 0)	n = Mid(n, 1, n.length - 1);
			while (Mid(n, n.length-1, 1) != ")" && n.length > 0) n = Mid(n, 0, n.length - 1);
			
			if (n.length <= 0) return "";
			return Mid(n, 1, n.length - 2);
		}
		
		public static function trimspaces(n:String):String {
			//Given a string n, remove the spaces around it
			while (Mid(n, 0, 1) == " " && n.length > 0)	n = Mid(n, 1, n.length - 1);
			while (Mid(n, n.length - 1, 1) == " " && n.length > 0) n = Mid(n, 0, n.length - 1);
			
			while (Mid(n, 0, 1) == "\t" && n.length > 0)	n = Mid(n, 1, n.length - 1);
			while (Mid(n, n.length - 1, 1) == "\t" && n.length > 0) n = Mid(n, 0, n.length - 1);
			
			if (n.length <= 0) return "";
			return n;
		}
		
		public static function isNumber(t:String):Boolean{
			if( isNaN(Number(t)) ) {
				return false;
			} else {
				return true;
		  }	
			return false;
		}
			
	  public static var sine:Vector.<Number> = new Vector.<Number>;
	  public static var cosine:Vector.<Number> = new Vector.<Number>;
		public static var glow:int, slowsine:int;
		public static var fastglow:int, fastglowdir:int;
		public static var glowdir:int;
		public static var tempstring:String;
	}
}
