package com.terry.engine {
	import flash.display.DisplayObject;
	import flash.events.MouseEvent;
	import flash.ui.Mouse;
	import flash.events.Event;
	
	/**
	 * This class helps contain and track the mouse pointer in your game.
	 * Automatically accounts for parallax scrolling, etc.
	 */
	public class mouse
	{		
		/**
		 * Current X position of the mouse pointer
		 */
		public static var x:int;
		/**
		 * Current Y position of the mouse pointer
		 */
		public static var y:int;
		public static var leftheld:Boolean;
		public static var rightheld:Boolean;
		/**
		 * Helper variable for tracking whether the mouse was just pressed or just released.
		 */
		protected static var _current:int;
		protected static var _rightcurrent:int;
		/**
		 * Helper variable for tracking whether the mouse was just pressed or just released.
		 */
		protected static var _last:int;
		protected static var _rightlast:int;
		
		public static var mouseoffstage:Boolean;
		public static var isdragging:Boolean;
		public static var holdingcat:Boolean;
		
		/**
		 * Constructor.
		 */
		public static function init(stage:DisplayObject):void
		{
			stage.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, handleMouseUp);
			//stage.addEventListener(MouseEvent.RIGHT_MOUSE_DOWN, handleRightMouseDown);
			//stage.addEventListener(MouseEvent.RIGHT_MOUSE_UP, handleRightMouseUp );
			//stage.addEventListener(MouseEvent.MOUSE_WHEEL, mousewheelHandler);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseOver);
			stage.addEventListener(Event.MOUSE_LEAVE, mouseLeave);
			
			mouseoffstage = false;
			isdragging = false;
			x = 0;
			y = 0;
			_current = 0;
			_rightcurrent = 0;
			_last = 0;
			_rightlast = 0;
		}		

		private static function mouseLeave(e:Event) :void {
			mouseoffstage = true;
			_current = 0;
			_rightcurrent = 0;
			_last = 0;
			_rightlast = 0;
			isdragging = false;
		}
		
		private static function mouseOver(e:MouseEvent) :void {
			mouseoffstage = false;
		}

		public static function mousewheelHandler( e:MouseEvent ):void {
			mousewheel = e.delta;
		}
		
		public static var mousewheel:int = 0;

		/**
		 * Called by the internal game loop to update the mouse pointer's position in the game world.
		 * Also updates the just pressed/just released flags.
		 * 
		 * @param	X			The current X position of the mouse in the window.
		 * @param	Y			The current Y position of the mouse in the window.
		 */
		public static function update(X:int,Y:int):void
		{
			x = X;
			y = Y;

			if((_last == -1) && (_current == -1))
				_current = 0;
			else if((_last == 2) && (_current == 2))
				_current = 1;
			_last = _current;
			
			if((_rightlast == -1) && (_rightcurrent == -1))
				_rightcurrent = 0;
			else if((_rightlast == 2) && (_rightcurrent == 2))
				_rightcurrent = 1;
			_rightlast = _rightcurrent;
		}
		
		/**
		 * Resets the just pressed/just released flags and sets mouse to not pressed.
		 */
		public static function reset():void
		{
			_current = 0;
			_last = 0;
			_rightcurrent = 0;
			_rightlast = 0;
		}
		
		/**
		 * Check to see if the mouse is pressed.
		 * 
		 * @return	Whether the mouse is pressed.
		 */
		public static function leftpressed():Boolean { return _current > 0; }
		public static function rightpressed():Boolean { return _rightcurrent > 0; }
		
		/**
		 * Check to see if the mouse was just pressed.
		 * 
		 * @return Whether the mouse was just pressed.
		 */
		public static function justleftpressed():Boolean { return _current == 2; }
		public static function justrightpressed():Boolean { return _rightcurrent == 2; }
		
		/**
		 * Check to see if the mouse was just released.
		 * 
		 * @return	Whether the mouse was just released.
		 */
		public static function justleftreleased():Boolean { return _current == -1; }
		public static function justrightreleased():Boolean { return _rightcurrent == -1; }
		
		/**
		 * Event handler so FlxGame can toggle the mouse.
		 * 
		 * @param	event	A <code>MouseEvent</code> object.
		 */
		public static function handleMouseDown(event:MouseEvent):void
		{
			isdragging = true;
			if(_current > 0) _current = 1;
			else _current = 2;
		}
		
		/**
		 * Event handler so FlxGame can toggle the mouse.
		 * 
		 * @param	event	A <code>MouseEvent</code> object.
		 */
		public static function handleMouseUp(event:MouseEvent):void
		{
			isdragging = false;
			if(_current > 0) _current = -1;
			else _current = 0;
		}
		
		public static function handleRightMouseDown(event:MouseEvent):void
		{
			if(_rightcurrent > 0) _rightcurrent = 1;
			else _rightcurrent = 2;
		}
		
		/**
		 * Event handler so FlxGame can toggle the mouse.
		 * 
		 * @param	event	A <code>MouseEvent</code> object.
		 */
		public static function handleRightMouseUp(event:MouseEvent):void
		{
			if(_rightcurrent > 0) _rightcurrent = -1;
			else _rightcurrent = 0;
		}

	}
}