package com.terry.engine {
	import flash.display.*;
	import flash.geom.*;
  import flash.events.*;
  import flash.net.*;
	import flash.text.*;
	import com.terry.engine.util.*;
	
	public class textbox{
		public static function init():void {
			for (var i:int = 0; i < 30; i++) {
				var t:textboxclass = new textboxclass;
				tb.push(t);
			}
			ntextbox = 0;
			
			txname = ""; activetb = -1;
			keepname = false; nameactive = false;
    }
		
		public static function createtextbox(t:String, xp:int, yp:int, c:int):void {
			if(ntextbox == 0) {
				//If there are no active textboxes, Z=0;
				m = 0; ntextbox++;
			}else {
				m = ntextbox; ntextbox++;
			}
			
			if (m < 20) {
				tb[m].clear();
				if (t == "") {
				  tb[m].showname = false;
					tb[m].numlines = 0;
		  	}else {
				  tb[m].showname = true;	
				  tb[m].line[0] = t;			
					tb[m].numlines = 1;
			  }
				tb[m].xp = xp;
				if (xp == -1) tb[m].xp = gfx.screenwidthmid - (((t.length / 2) + 1) * 8);
				tb[m].yp = yp;
				tb[m].col = c;
				tb[m].resize();
			}
		}
		
		public static function textboxcleanup():void {
			var i:int = ntextbox - 1; while (i >= 0 && !tb[i].active) { ntextbox--; i--; }
		}
		
		public static function textboxcenter():void {
			tb[m].centerx(); tb[m].centery();
		}
		
		public static function textboxcenterx():void {
			tb[m].centerx(); 
		}
		
		
		public static function textboxtopcenter():void {
			tb[m].centerx(); 
			tb[m].yp = 5; 
		}
		
		public static function textboxwidth():int {
			return tb[m].w; 
		}
		
		public static function textboxmove(xo:int, yo:int):void {
			tb[m].xp += xo; tb[m].yp += yo;
		}
		
		public static function textboxmoveto(xo:int):void {
			tb[m].xp = xo;
		}
		
		public static function textboxcentery():void {
		  tb[m].centery();
		}
		
		public static function textboxadjust():void {
		  tb[m].adjust();
		}
		
		public static function textboxposition(speaker:int):void {
			speakernum = speaker;
			if (speakernum > -1) {
				//Position textbox relative to speaker entity
				tb[m].resize();
				
				//Ok, we need a actual pixel position on screen first... Red dot is a debugging variable, sorta
				reddotx = obj.entities[speakernum].xp - map.camerax;
				reddoty = obj.entities[speakernum].yp - map.cameray - 4 - 16;
				
				reddotx -= (tb[m].w / 2);
				gfx.textbubblex = int((tb[m].w / 2) / 16) + 2;
				
				//If player is facing up, then the textbox is below them. In all other cases, it's above.
				//if (obj.entities[speakernum].dir == 1) {
				//	reddoty += 32 + 5;
				//}else{
					reddoty -= tb[m].h + 5;
				//}
				
				tb[m].xp = reddotx;
				tb[m].yp = reddoty;
			}
			
			tb[m].adjust();
		}
		
		public static function addline(t:String):void {
		  //tb[m].addline(t);
			stringbreak = ""; stringbreakcounter = 0; stringbreakline = 0;
			
			while (stringbreakcounter < font.len(t)) {
				stringbreak += help.Mid(t, stringbreakcounter);
				//if (len(stringbreak) >= 280) {
				if (font.len(stringbreak) >= 240) {
					//Ok: stringbreak now contains a chunk of a sentance.
					//We need to work back and find the last space in this, then readjust everything.
					while (help.Mid(stringbreak, stringbreak.length-1) != " ") {
						stringbreak = help.Mid(stringbreak, 0, stringbreak.length - 1);
						stringbreakcounter--;
					}
					tb[m].addline(stringbreak);
					stringbreakline++;
					stringbreak = "";
				}
				stringbreakcounter++;
			}
			
			
			//Anything leftover?
			if (font.len(stringbreak) > 0) {
				tb[m].addline(stringbreak);
				stringbreakline++;
				stringbreak = "";
			}
		}
		
		public static function starttextbox():void {
		  tb[m].textboxstate = 1;
			activetb = m;
		}
		
		public static function textboxremove():void {
			//Remove all textboxes
			for (var i:int = 0; i < ntextbox; i++) {
				tb[i].remove();
			}
		}
		
		public static function textboxremovefast():void {
			//Remove all textboxes
			for (var i:int = 0; i < ntextbox; i++) {
				tb[i].removefast();
			}
		}
		
		public static function textboxactive():void {
			//Remove all but the most recent textbox
			for (var i:int = 0; i < ntextbox; i++) {
				if (m != i) tb[i].remove();
			}
		}
		
		public static function tbprint(cline:int, tbline:int, tbcursor:int, x:int, y:int, t:String, r:int, g:int, b:int):void {
			//Special version of print which automatically handles line positions, tickers, etc
			if (x == -1) x = gfx.screenwidthmid - (font.len(t) / 2);
			//if (y == -1) y = 56 - ((tbsize - 1) * 4);
			
			if (cline < tbline) {
				//Always draw
				//if (cline == tbsize) t += " _";
			  font.print(x, y + (cline * 12), t, r, g, b);
			}else if (cline == tbline) {
				//In the process of drawing
				tempstring = "";
				for (var j:int = 0; j < t.length; j++) if (tbcursor > j) tempstring += t.charAt(j);
				//tempstring += " _";
			  font.print(x, y + (cline * 12), tempstring, r*0.75, g*0.75, b*0.75);
			}
		}
		
		public static function updatetextboxes():void {
			//Textbox animations
			for (var i:int = 0; i < ntextbox; i++) {
				tb[i].update();
				
				//Sound effects/Fast text progression here
				if (tb[i].textboxstate == 2) {
					if (tb[i].textboxdelay <= 0) {
						if(game.jumpheld) tb[i].tbcursor+=4;
						talktimer--;
						if (talktimer <= 0) {
							music.playef("text_window_changes");
							//music.playef(6);
							talktimer = 4;
						}				
					}
				}else if (tb[i].textboxstate == 5) {
					activetb = -1;
					tb[i].textboxstate = 0;
					tb[i].active = false;
				}
			}
		}
		
		public static var m:int;
		public static var activetb:int;
		public static var ntextbox:int;
		public static var tb:Vector.<textboxclass> = new Vector.<textboxclass>;
		public static var txname:String, tempstring:String;
		public static var keepname:Boolean, nameactive:Boolean;
		public static var stringbreak:String, stringbreakcounter:int, stringbreakline:int;
		public static var speaker:String, speakernum:int;
		public static var activenpc:int, activenpcscript:String;
		public static var reddotx:int = 0, reddoty:int = 0;
		public static var talktimer:int = 0;
		public static var col:int = 0;
		/*
		[Embed(source = "../../../../data/graphics/font/font.swf", 
		symbol = "FFF Aquarius Bold Condensed")]
		public static var ttffont:Class;
		*/
	}
}