import com.terry.engine.*;
import gamecontrol.*;

public function mainloop(e:TimerEvent):void {
	_current = getTimer();
	if (_last < 0) _last = _current;
	_delta += _current - _last;
	_last = _current;
	if (_delta >= _rate){
		_delta %= _skip;
		while (_delta >= _rate){
			_delta -= _rate;
			input();
			logic();
		}
		render();
		e.updateAfterEvent();
	}
}

public function input():void {
	if (game.infocus) {
		mouse.update(mouseX, mouseY);
		game.mx = (mouse.x / def.SCREENSCALE);
		game.my = (mouse.y / def.SCREENSCALE);
		
	  game.keypoll();
		
		switch(game.gamestate) {
			case def.TITLEMODE:	titleinput(); break;
			case def.GAMEOVER: gameoverinput(); break;
			case def.PACKINGMODE: gameinput(); break;
			case def.TRASHMODE: trashinput(); break;
			case def.WALKABOUTMODE: walkaboutgameinput(); break;
			case def.CLICKTOSTART: if (mouse.justleftpressed()) { 
				game.gamestate = def.TITLEMODE; 
				music.play("titlescreen");
			}	break;
		}
	}
}

public function logic():void {
	if (!game.infocus) {
		if (game.globalsound > 0) {
			game.globalsound = 0;
			SoundMixer.soundTransform = new SoundTransform(0);
		}
		music.processmusic();
		gfx.processfade();
		help.updateglow();
		if (control.showcontrols > 0) control.showcontrols--;
	}else {		
		game.runscript();
		textbox.updatetextboxes();
		
		switch(game.gamestate) {
			case def.TITLEMODE: titlelogic(); break;
			case def.GAMEOVER: gameoverlogic(); break;
			case def.PACKINGMODE: gamelogic(); break;
			case def.TRASHMODE: trashlogic(); break;
			case def.WALKABOUTMODE: walkaboutgamelogic(); break;
		}
		
		obj.cleanup();
		music.processmusic();
		gfx.processfade();
		help.updateglow();
		if (control.showcontrols > 0) control.showcontrols--;
		
		//Mute button
		music.processmute();
	}
}

public function render():void {
	gfx.backbuffer.lock();
	if (!game.infocus) {
		gfx.outoffocusrender();
	}else {
		gfx.cls();
		
		switch(game.gamestate) {
			case def.TITLEMODE: titlerender(); break;
			case def.GAMEOVER: gameoverrender(); break;
			case def.PACKINGMODE: gamerender(); break;
			case def.TRASHMODE: trashrender(); break;
			case def.WALKABOUTMODE: walkaboutgamerender(); break;
			case def.CLICKTOSTART: gfx.clicktostart(); break;
		}
		
		if (!mouse.mouseoffstage) {
			if (mouse.holdingcat) {
				
			}else if (mouse.isdragging) {
				gfx.drawtile((mouse.x / 2) - 8, (mouse.y / 2) - 8, 1);
			}else{
				gfx.drawtile((mouse.x / 2) - 8, (mouse.y / 2) - 8, 0);
			}
		}
		
		gfx.drawfade();
		
		if (control.showcontrols > 0) {
			if (control.showcontrols < 15) {
				gfx.fillrect(gfx.screenwidthmid-100, 225 + (15-control.showcontrols), 200, 20, 255, 255, 255);
				if (int(control.showcontrols / 20) % 2 == 0) {
					gfx.print(0, 225 + (15-control.showcontrols), "Control with MOUSE only", 0, 0, 0, true);
				}else {
					gfx.print(0, 225 + (15-control.showcontrols), "Control with MOUSE only", 64, 64, 64, true);
				}
			}else{
				gfx.fillrect(gfx.screenwidthmid-100, 225, 200, 20, 255, 255, 255);
				if (int(control.showcontrols / 20) % 2 == 0) {
					gfx.print(0, 225, "Control with MOUSE only", 0, 0, 0, true);
				}else {
					gfx.print(0, 225, "Control with MOUSE only", 64, 64, 64, true);
				}
			}
		}
		
	  gfx.screenrender();
	}
}
