import com.terry.engine.*;
import gamecontrol.control;

public static function load(t:String):void {
	//loads script name t into the array
	position = 0; scriptlength = 0; parsetext = false;
	control.destinationaction = "null";
	
	if (t == "intro") {
		add("delay(30)");
		add("say(){");
		add("  Right! We should get this stuff packed. Thanks so much for coming to help!");
		add("}");
		add("say(){");
		add("  The cab'll be here soon.");
		add("}");
	}else if (t == control.dumpstername) {
		if (control.carryingtrash) {			
			add("changetotrashmode()");
		}else {
			if (!control.suitcasepacked || control.everythingtrashed) {
				add("say(){");
				add("  The neighbours probably won't mind me filling this up.");
				add("}");
			}else {
				add("say(){");
				add("  Forgot the bins. Doh!");
				add("}");
			}
		}
	}else if (t == control.catname) {
		if (control.everythingtrashed) {
			if (control.outcome == control.SPY) {
				load("spyending");
			}else{
				control.gamephase = control.GAMEPHASE_CATPACKING;
				add("changetopackingmode()");
			}
		}else {
			if (control.catclicks % 2 == 0) {
				music.playef("catpurr", 4000);
			  control.catclicks++;
			}else {
				music.playef("catmeow1");
			  control.catclicks++;
			}
		}
	}else if (t == control.cagename) {
		if (control.everythingtrashed) {
			if (control.outcome == control.SPY) {
				load("spyending");
			}else{
				control.gamephase = control.GAMEPHASE_CATPACKING;
				add("changetopackingmode()");
			}
		}else{
			add("say(){");
			add("  I'll deal with that in a minute.");
			add("}");
		}
	}else if (t == control.binname) {
		if (control.suitcasepacked) {
			control.carryingtrash = true;
			control.bininflat = false;
		}else {
			add("say(){");
			add("  I've not packed yet!");
			add("}");
		}
	}else if (t == control.suitcasename) {
		if (control.everythingtrashed) {
			add("say(){");
			add("  Nearly ready to go.");
			add("}");
		}else if (control.suitcasepacked) {
			add("say(){");
			add("  Ready! Just need to take care of the trash...");
			add("}");
		}else{
			add("changetopackingmode()");
		}
	}else if (t == "suitcase_opened") {
		if (control.gamephase != control.GAMEPHASE_CATPACKING) {
			music.playef("bag_mode_enter");
			music.play("packing");
		}else {
			music.play("cat");
		}
		add("delay(30)");
		add("say(){");
		add("  Let's pack!");
		add("}");
	}else if (t == "suitcase_packed") {
		if (control.catpacked) {
			load("guestatdoor");
		}else if (control.issuitcaseempty()) {
			//Special naked ending!
			music.playef("close_bag");
			add("delay(30)");
			add("face(player,down)");
			add("movecharacter(player,catcageright)");
			add("wait(movement)");
			add("face(player,down)");
			add("say(){");
			add("  Now I can be one with nature!");
			add("}");
			add("undress()");
			add("delay(120)");
			add("movecharacter(player,suitcaseright)");
			add("wait(movement)");
			add("movecharacter(player,doorright)");
			add("wait(movement)");
			add("delay(10)");
			
			add("movecharacter(player,door)");
			add("wait(movement)");
			
			add("delay(30)");
			add("opendoor");
			add("delay(60)");
			add("hideplayer");
			add("delay(60)");
			
			add("delay(210)");
			add("endgame()");
		}else {
			music.playef("close_bag");
			add("delay(30)");
			add("face(player,down)");
			add("say(){");
			add("  Thanks for helping me pack!");
			add("}");
		}
	}else if (t == "everythingtrashed") {
		if (control.outcome == control.SPY) {
			add("delay(30)");
			add("say(){");
			add("  One final matter to deal with...");
			add("}");
			
			music.play("endingspy");
		}else{
			add("delay(30)");
			add("say(){");
			add("  Ok! Just one thing left.");
			add("}");
			
			music.play("outdoors");
		}
	}else if (t == control.flowername) {
		add("say(){");
		add("  Damn, I can't fit the plant. I hope the new tenants take care of it.");
		add("}");
	}else if (t == control.exitname) {
		if (control.catpacked) {
			load("guestvisit");
		}else if (control.suitcasepacked) {
			add("opendoor");
			add("delay(25)");
			if (control.outcome == control.SPY) {				
				add("changemap(outside_future,19,8)");
				add("delay(120)");					
			}else{
				if (!control.insuitcase("razor")) {
					add("changemap(outside_cold,19,8)");
					add("delay(120)");					
				}else {
					add("changemap(outside_warm,19,8)");
					add("delay(120)");	
				}
			}
		}else {
			add("say(){");
			add("  Need to finish packing...");
			add("}");
		}
	}else if (t == control.flatname) {
		add("changemap(apartment,12,6)");
		add("delay(120)");
  }else if (t == "closedoorbehindyou") {
		add("delay(45)");
		add("closedoor()");
	}else if (t == "nopassport") {
		add("textboxstyle(1)");
		add("say(){");
		add("  Shit! My passport!");
		add("  Where's my passport?");
		add("}");
		add("textboxstyle(0)");
	}else if (t == "finishedpacking") {
		music.play("packingreview");
		//Sets control.outcome to either MOVING_IN, BREAKING_UP or NEW_JOB
		//NEW_JOB doesn't really have any text yet.
		//Sets noclothes to T/F (If noclothes == TRUE it also sets outcome to BREAKING_UP)
		control.getoutcome(); 
		
		if (control.issuitcaseempty()) {
			// Special Case: Empty suitcase
			add("say(){");
			add("  I don't need any of this stuff.");
			add("}");
		}else if (control.dildo_ukelele()) {
			// Special Case: Just Dildo + Ukelele
			add("hideborders()");
			add("delay(60)");
			
			add("highlight(smalldildo)");
			add("highlight(ukelele)");
			add("say(){");
			add("  A bottle of whiskey on top, and I'm sorted!");
			add("}");
			add("highlight(off)");
			
			add("delay(60)");
		}else if (control.dildo_teddy()) {
			// Special Case: Just Dildo + Teddy
			add("hideborders()");
			add("delay(60)");
			
			add("highlight(smalldildo)");
			add("highlight(teddy)");
			add("say(){");
			add("  You'll always love me, right, Mr. Snuggles?");
			add("}");
			add("highlight(off)");
			
			add("delay(60)");
		}else if (control.spycase()) {
			//Special case: spy ending!
			add("hideborders()");
			add("delay(60)");
			
			add("say(){");
			add("  Alright, this is everything.");
			add("}");
			
			add("delay(60)");
			
			add("highlight(suit1)");
			add("highlight(suit2)");
			add("highlight(gun)");
			add("say(){");
			add("  Time for my next covert operation.");
			add("}");
			add("highlight(off)");
			
			if (control.insuitcase("passport")) {
				add("delay(30)");
				
				add("highlight(passport)");
				add("say(){");
				add("  This isn't my real name. It's not even my fake name.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("travelcard")) {
				add("delay(30)");
				
				add("highlight(travelcard)");
				add("say(){");
				add("  A swiss travel card. This is my only lead.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("smalldildo")) {
				add("delay(30)");
				
				add("highlight(smalldildo)");
				add("say(){");
				add("  The enemy spies thought the last place I'd look would be my own vagina. They were wrong!");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("fork")) {
				add("delay(30)");
				
				add("highlight(fork)");
				add("say(){");
				add("  No, it's just a regular fork. The prongs aren't correctly aligned. It's basically a torture device, but I have a sentimental attachment.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("knife")) {
				add("delay(30)");
				
				add("highlight(knife)");
				add("say(){");
				add("  Damn, I'm all out of spy butter.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("hand")) {
				add("delay(30)");
				
				add("highlight(hand)");
				add("say(){");
				add("  I still need these prints.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("postit")) {
				add("delay(30)");
				
				add("highlight(postit)");
				add("say(){");
				add("  For top secret messages, like \"please clean up after yourself\".");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("bottle")) {
				add("delay(30)");
				
				add("highlight(bottle)");
				add("say(){");
				add("  The pee never lies.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("mug")) {
				add("delay(30)");
				
				add("highlight(mug)");
				add("say(){");
				add("  Cutting edge amplification device. For listening through walls.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("earplugs")) {
				add("delay(30)");
				
				add("highlight(earplugs)");
				add("say(){");
				add("  Top secret spy headset. Also noise-cancelling!");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("mouse")) {
				add("delay(30)");
				
				add("highlight(mouse)");
				add("say(){");
				add("  For distracting guard cats.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("book")) {
				add("delay(30)");
				
				add("highlight(book)");
				add("say(){");
				add("  Top secret documents.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("chocolate")) {
				add("delay(30)");
				
				add("highlight(chocolate)");
				add("say(){");
				add("  Why did they have to hide the microchip in something that looks so delicious?");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("razor")) {
				add("delay(30)");
				
				add("highlight(razor)");
				add("say(){");
				add("  If I need to change my identity, I can shave my legs and nobody will recognise me.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("scarf")) {
				add("delay(30)");
				
				add("highlight(scarf)");
				add("say(){");
				add("  Oh, Spy " + control.boyfriend + " \"left\" his \"scarf\" here.");
				add("}");
				
				add("textboxstyle(1)");
		    
				add("say(){");
				add("  Hello Spy " + control.boyfriend + " !");
				add("}");
				
				add("textboxstyle(0)");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("picture")) {
				add("delay(30)");
				
				add("highlight(picture)");
				add("say(){");
				add("  None of my kids know me by the same name.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("teddy")) {
				add("delay(30)");
				
				add("highlight(teddy)");
				add("say(){");
				add("  People'd figure a spy bear would have a hidden camera, but it's just to keep me company during stakeouts.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("ukelele")) {
				add("delay(30)");
				
				add("highlight(ukelele)");
				add("say(){");
				add("  They gave me this spy ukulele in HQ, but I can't figure out what it does.");
				add("}");
				
				add("say(){");
				add("  ...");
				add("}");
				
				add("say(){");
				add("  I'm starting to suspect it may just be a ukulele.");
				add("}");
				
				add("highlight(off)");
			}
			
			add("delay(60)");
			
			add("say(){");
			add("  Ok! That's it!");
			add("}");
		}else {
			//All other cases
			add("hideborders()");
			add("delay(60)");
			
			add("say(){");
			add("  Alright, this is everything.");
			add("}");
			
			add("delay(60)");
			
			if (control.insuitcase("partyclothes")) {
				add("highlight(partyclothes)");
			  add("say(){");
				add("  I just broke up with " + control.boyfriend + ".");
				add("}");
				
				add("delay(30)");
				add("say(){");
				add("  I hope these still fit.");
				add("}");
				add("highlight(off)");
				
				if (control.insuitcase("suit1") || control.insuitcase("suit2")) {
					if (control.insuitcase("teddy")) {
						add("delay(30)");
						add("highlight(suit1)");
						add("highlight(suit2)");
						add("highlight(teddy)");
						
						add("say(){");
						add("  " + control.boyfriend + " is suing for custody of Mr. Snuggles.");
						add("}");
						add("highlight(off)");
					}
				}
			}else if (control.insuitcase("normalclothes")) {
				add("highlight(normalclothes)");
				add("say(){");
				add("  I'm moving in with " + control.boyfriend +"!");
				add("}");
				
				add("delay(30)");
				add("say(){");
				add("  Wonder where he's gonna keep");
				add("  his clothes now?");
				add("}");
				add("highlight(off)");
			}else{			
				if (control.insuitcase("suit1") || control.insuitcase("suit2")) {
					add("highlight(suit1)");
					add("highlight(suit2)");
					
					add("say(){");
					add("  Finally got promoted!");
					add("}");
					
					add("delay(30)");
					
					add("say(){");
					add("  I'm not going to have much time for casualwear at my new job.");
					add("}");
					add("highlight(off)");
				}else {
					add("say(){");
					add("  I just broke up with " + control.boyfriend + ".");
					add("}");
					
					add("delay(30)");
					add("say(){");
					add("  Just got the shirt on my back now. I think I can work out one naked washing day a week.");
					add("}");
				}
			}
			
			if (control.insuitcase("knife") && control.insuitcase("fork") && (control.insuitcase("suit1") || control.insuitcase("suit2"))) {
				add("delay(30)");
				
				add("highlight(knife)");
				add("highlight(fork)");
				add("highlight(suit1)");
				add("highlight(suit2)");
				add("say(){");
				add("  Power lunches!");
				add("}");
				add("highlight(off)");
			}
			
			if (control.insuitcase("ukelele")) {
				if (control.insuitcase("earplugs")) {					
					add("delay(30)");
					
					add("highlight(ukelele)");
					add("highlight(earplugs)");
					add("say(){");
					add("  I don't much care for music, but people tell me I'm great.");
					add("}");
					add("highlight(off)");
				}else if (!control.insuitcase("smalldildo")) {
					add("delay(30)");
					
					add("highlight(ukelele)");
					add("say(){");
					add("  Who needs sex toys when you have a ukulele!");
					add("}");
					add("highlight(off)");
				}else{
					add("delay(30)");
					
					add("highlight(ukelele)");
					add("say(){");
					add("  This ukulele will be a great way to make new friends!");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("teddy")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
				  add("highlight(teddy)");
					add("say(){");
					add("  " + control.boyfriend + " said he wants to sew a new hole in you. It'll be a great way for all three of us to connect, Mr. Snuggles!");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
				  add("highlight(teddy)");
					add("say(){");
					add("  At least I have you, Mr. Snuggles. I'll always have Mr. Snuggles.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
				  add("highlight(teddy)");
					add("say(){");
					add("  It's lonely at the top, Mr. Snuggles.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("smalldildo")) {
				if (control.noclothes) {
					add("delay(30)");
					
					add("highlight(smalldildo)");
					add("say(){");
					add("  I'm not bringing any clothes. Am I letting myself go a little? Well, whatever.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(smalldildo)");
					add("say(){");
					add("  It's " + control.boyfriend + "'s favourite.");					
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(smalldildo)");
					add("say(){");
					add("  It was " + control.boyfriend + "'s favourite.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(smalldildo)");
					add("say(){");
					add("  For ten years of service at my job.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("teddy") && control.insuitcase("smalldildo")) {
				add("delay(30)");
				
				add("highlight(smalldildo)");
				add("highlight(teddy)");
				add("say(){");
				add("  I need these for the main project in the latest Craft Monthly.");
				add("}");
				add("highlight(off)");
			}
			
			if (control.insuitcase("scarf")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(scarf)");
					add("say(){");
					add("  Oh, " + control.boyfriend + " left his scarf here. I'll bring it along.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(scarf)");
					add("say(){");
					add("  It still smells of him.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(scarf)");
					add("say(){");
					add("  I stole this from an orphan.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("hand")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(hand)");
					add("say(){");
					add("  I hope " + control.boyfriend + " won't be jealous if he finds this.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(hand)");
					add("say(){");
					add("  Huh, where did I put the rest?");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(hand)");
					add("say(){");
					add("  The previous head of division...");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("mug")) {
				if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(mug)");
					add("say(){");
					add("  " + control.boyfriend + " used to come in my coffee when I wasn't looking. I guess he wasn't all bad!");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("chocolate")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(chocolate)");
					add("say(){");
					add("  We're both vegan, but I still have a top secret supply for emergencies.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(chocolate)");
					add("say(){");
					add("  I'll need more where this comes from.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(chocolate)");
					add("say(){");
					add("  This is victory chocolate. For when I become CEO.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("razor")) {
				add("delay(30)");
				
				add("highlight(razor)");
				add("say(){");
				add("  I hate summertime.");
				add("}");
				
				add("highlight(off)");
			}
			
			if (control.insuitcase("earplugs")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(earplugs)");
					add("say(){");
					add("  I can't stand to hear him grunting during sex.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(earplugs)");
					add("say(){");
					add("  From one noisy neighbourhood to another. Grim.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("bottle")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(bottle)");
					add("say(){");
					add("  It's so hard to part with some things. I don't know why I have such a sentimental attachment.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(bottle)");
					add("say(){");
					add("  He let me keep this to remember him by. It's nice to part on such good terms!");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(bottle)");
					add("say(){");
					add("  This is a whole year's random drug tests' worth of pee!");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("postit")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(postit)");
					add("say(){");
					add("  I'm going to use these to make cute pixel art pictures of what " + control.boyfriend + "'s doing wrong.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(postit)");
					add("say(){");
					add("  I'll need this for the next round of redundancy notices.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("knife") && control.insuitcase("gun") && !control.insuitcase("fork")) {
				add("delay(30)");
				
				add("highlight(knife)");
				add("highlight(gun)");
				add("say(){");
				add("  This is all the cutlery I need.");
				add("}");
				add("highlight(off)");
			}
			
			if (control.insuitcase("gun")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(gun)");
					add("say(){");
					add("  I'll get " + control.boyfriend + " a matching gun - it'll be super cute!");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(gun)");
					add("say(){");
					add("  Gonna try chatting up that cute guy down at the firing range.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("travelcard")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(travelcard)");
					add("say(){");
					add("  I won't need this now, but I don't want to forget our time apart.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(travelcard)");
					add("say(){");
					add("  They still won't cover my damn travel costs.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("mouse")) {
				if (control.outcome != control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(mouse)");
					add("say(){");
					add("  Mew mew mew.");
					add("}");
					add("highlight(off)");
				}else {
					add("delay(30)");
					
					add("highlight(mouse)");
					add("say(){");
					add("  I'll just get a new cat in my new place.");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("book")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(book)");
					add("say(){");
					add("  \"The Art of War.\"");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(book)");
					add("say(){");
					add("  \"Cooking for One, for Beginners.\"");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(book)");
					add("say(){");
					add("  \"The Virtue of Selfishness.\"");
					add("}");
					add("highlight(off)");
				}
			}
			
			if (control.insuitcase("picture")) {
				if (control.outcome == control.MOVING_IN) {
					add("delay(30)");
					
					add("highlight(picture)");
					add("say(){");
					add("  Aww, " + control.boyfriend + " looked so cute when he had hair.");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.BREAKING_UP) {
					add("delay(30)");
					
					add("highlight(picture)");
					add("say(){");
					add("  That's me and " + control.boyfriend + ". No point forgetting the good times, right?");
					add("}");
					add("highlight(off)");
				}else if (control.outcome == control.NEW_JOB) {
					add("delay(30)");
					
					add("highlight(picture)");
					add("say(){");
					var tmp:int = int(Math.random() * 2);
					if (tmp == 0) {
						add("  An old family photograph. My mother worked so hard. Such an inspiration.");
					}else{
						add("  An old family photograph. My father worked so hard. Such an inspiration.");
					}
					add("}");
					add("highlight(off)");
				}
			}
			
			add("delay(60)");
			
			add("say(){");
			add("  Ok! That's it!");
			add("}");
		}
			
		add("delay(30)");
		
		add("changetowalkabout_afterpacking()");
	}else if (t == "takeoutthetrash") {
		add("delay(60)");
		add("say(){");
		add("  Let's trash!");
		add("}");
		
		var itemtotrash:String = "";
		for (var i:int = 0; i < control.numitems; i++) {
			itemtotrash = control.trashordernum[i];
			if (control.trashed(itemtotrash)) {
				
				add("wait(trash)");
				add("trash(" + itemtotrash+")");
				add("wait(trash)");
				
				if (itemtotrash == "ukelele") {
					if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  No place for ukuleles in the boardroom.");
						add("}");
					}else if (control.outcome != control.SPY) {
						var tempuke:int = Math.random() * 100;
						if (control.outcome == control.BREAKING_UP) {
							if (tempuke < 20) {
								add("say(){");
								add("  It's a dumb instrument anyway.");
								add("}");	
							}else if (tempuke < 40) {
								add("say(){");
								add("  Turns out you can't learn to play in an hour.");
								add("}");	
							}else if (tempuke < 60) {
								add("say(){");
								add("  I couldn't keep the damn thing in tune.");
								add("}");	
							}else if (tempuke < 80) {
								add("say(){");
								add("  I only played it to annoy him anyway.");
								add("}");	
							}else {
								add("say(){");
								add("  " + control.boyfriend + " got really turned on when I played the ukulele. I didn't even know any songs!");
								add("}");	
							}
						}else {
							if (tempuke < 33) {
								add("say(){");
								add("  It's a dumb instrument anyway.");
								add("}");	
							}else if (tempuke < 66) {
								add("say(){");
								add("  Turns out you can't learn to play in an hour.");
								add("}");	
							}else{
								add("say(){");
								add("  I couldn't keep the damn thing in tune.");
								add("}");	
							}
						}
					}
				}else if (itemtotrash == "smalldildo") {	
					if (control.outcome == control.MOVING_IN && control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  Oh that? that's not mine - that's the cat's: I've sent mine ahead in freight.");
						add("}");	
					}
				}else if (itemtotrash == "scarf") {	
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  He has the worst scarves. If he asks I'll just tell him we lost it.");
						add("}");	
					}else if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  Fuck him, fuck him and his fucking scarf.");
						add("}");	
					}else if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  I fired him after we broke up.");
						add("}");	
					}
				}else if (itemtotrash == "postit") {	
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  " + control.boyfriend + " says I have a problem.");
						add("}");	
					}else if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  I can't believe he used MY post-it notes to break up with me.");
						add("}");	
					}else if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  I have a PA now to be passive aggressive for me.");
						add("}");	
					}
				}else if (itemtotrash == "book") {	
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  \"A Room of One's Own.\"");
						add("}");	
					}else if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  \"Cooking for Two.\"");
						add("}");	
					}else if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  \"A Theory of Justice.\"");
						add("}");	
					}
				}else if (itemtotrash == "teddy") {	
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  Goodbye Mr. Snuggles :(");
						add("}");	
					}else if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  You were a present from " + control.boyfriend + ", so I had to pretend to like you, Mr. Snuggles.");
						add("}");	
						add("say(){");
						add("  But I don't like you, Mr. Snuggles.");
						add("}");	
						add("say(){");
						add("  I hate you.");
						add("}");	
					}else if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  Nigel got a gold watch when he was promoted. I got a teddy bear.");
						add("}");	
					}
				}else if (itemtotrash == "razor") {	
					if (control.outcome != control.SPY) {
						add("say(){");
						add("  Winter's on the way. I'll restock in March.");
						add("}");	
					}
				}else if (itemtotrash == "chocolate") {	
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  " + control.boyfriend + "'s ex was so thin...");
						add("}");	
					}else if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  Actually, I think I need this.");
						add("}");	
					}else if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  Performance reviews are coming up, and people seem convinced I like chocolate.");
						add("}");	
					}
				}else if (itemtotrash == "gun") {	
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  I really hated living alone.");
						add("}");	
					}else if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  I never lost an argument with him. I don't understand why things didn't work out.");
						add("}");	
					}else if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  Time for a change of management style!");
						add("}");	
					}
				}else if (itemtotrash == "bottle") {
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  Now that we're living together, I can get this fresh.");
						add("}");	
					}else if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  I don't even remember if this was mine or his.");
						add("}");	
					}else if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  I wouldn't have gotten the new job without you. Mwah!");
						add("}");	
					}
				}else if (itemtotrash == "mouse") {	
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  " + control.boyfriend + "'s allergic.");
						add("}");	
					}else if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  Got fed up of having fur on my suits.");
						add("}");	
					}
				}else if (itemtotrash == "earplugs") {	
					if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  I couldn't stand to hear him grunting during sex.");
						add("}");	
					}
				}else if (itemtotrash == "travelcard") {
					if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  Long distance was tough.");
						add("}");	
					}
				}else if (itemtotrash == "suit1") {
					if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  No more going to his shitty work dinners.");
						add("}");	
						control.shittyworkdinners = true;
					}
				}else if (itemtotrash == "suit2") {
					if (control.outcome == control.BREAKING_UP && !control.shittyworkdinners) {
						add("say(){");
						add("  No more going to his shitty work dinners.");
						add("}");	
					}
				}else if (itemtotrash == "normalclothes") {
					if (control.outcome == control.BREAKING_UP) {
						add("say(){");
						add("  " + control.boyfriend + " got more milage out of these than I did.");
						add("}");	
					}
				}else if (itemtotrash == "partyclothes") {
					if (control.outcome == control.NEW_JOB) {
						add("say(){");
						add("  I can't give these to a charity shop, they're haute couture!");
						add("}");	
					}else if (control.outcome == control.MOVING_IN) {
						add("say(){");
						add("  I got nervous on my first date, and threw up over my new dress. That made him nervous, and he threw up on it as well! Aww.");
						add("}");
					}
				}
			}
		}
		
		add("wait(trash)");
		add("trash(bin)");
		add("delay(60)");
		
		add("changetowalkabout_aftertrash()");
	}else if (t == "guestatdoor") {
		add("delay(45)");
		music.playef("doorknock");
		add("face(player,up)");
	}else if (t == "guestvisit") {
		add("opendoor");
		add("delay(10)");
		
		add("movecharacter(player,suitcaseabove)");
		add("wait(movement)");
		add("face(player,up)");
		add("addcharacter(" + control.guest + ",door)");
		add("delay(90)");
		
		add("movecharacter(" + control.guest + ",suitcaseright)");
		add("movecharacter(player,suitcaseleft)");
		
		add("wait(movement)");
		
		add("face(player,right)");
		add("face(" + control.guest + ",left)");
		add("delay(90)");
		
		add("textboxstyle(2)");
		
		if (control.guest == "ex") {		
			add("say(player){");
			add("  " + control.boyfriend + ", hey.");
			add("}");	
		}else if (control.guest == "mum") {
			add("say(player){");
			add("  Mum, hi.");
			add("}");
			add("say(mum){");
			add("  I knew you weren't mature enough to take responsibility for a cat.");
			add("}");
			add("say(player){");
			add("  Thanks for helping me out, mum.");
			add("}");
			add("say(mum){");
			add("  When I was your age, I had three children.");
			add("}");
			add("say(player){");
			add("  Yes, mum.");
			add("}");
			add("say(mum){");
			add("  Three children and a husband!");
			add("}");
			add("say(player){");
			add("  Yes, mum.");
			add("}");
			add("say(mum){");
			add("  And *my* husband had a job.");
			add("}");
			add("say(player){");
			add("  Thanks for helping mum.");
			add("}");
		}else if (control.guest == "coworker") {
			add("say(coworker){");
			add("  Hey boss.");
			add("}");
			add("say(player){");
			add("  Thanks so much for offering to take care of the cat for me.");
			add("}");
			add("say(coworker){");
			add("  Oh...no problem...");
			add("}");
		}
		
		add("delay(90)");
		add("movecharacter(" + control.guest + ",catcageright)");
		add("wait(movement)");
		
		if(control.guest == "ex") {		
			add("face(" + control.guest + ",left)");
			add("say(ex){");
			add("  Hey, kitty kitty...");
			add("}");	add("delay(15)");
		}
		
		add("movecharacter(" + control.guest + ",catcage)");
		add("delay(25)");
		add("getcatcage()");
		add("delay(90)");
		
		if(control.guest == "ex") {		
			add("face(" + control.guest + ",left)");
			add("say(ex){");
			add("  Mew mew mew...");
			add("}");	add("delay(15)");
		}
		
		add("movecharacter(" + control.guest + ",catcageright)");
		add("wait(movement)");
		add("movecharacter(" + control.guest + ",suitcaseright)");
		add("wait(movement)");
		
		add("face(" + control.guest + ",left)");
		add("delay(90)");
		
		if (control.guest == "ex") {
			if (control.insuitcase("bottle")) {
				add("say(ex){");
				add("  Hey, um, all the best in your new place.");
				add("}");
				add("say(player){");
				add("  Thanks, you too.");
				add("}");
			}else if (control.insuitcase("scarf")) {
				add("say(ex){");
				add("  Oh, by any chance, have you seen my scarf?");
				add("}");
				add("say(player){");
				add("  Nope...");
				add("}");
			}else{
				add("say(ex){");
				add("  Oh, bye.");
				add("}");
			}
		}else if (control.guest == "mum") {
			add("say(mum){");
			add("  Hmpf. I suppose I'll see you for");
			add("  Christmas then?");
			add("}");
			add("say(player){");
			add("  Yes mum, thanks so much.");
			add("}");
		}else if (control.guest == "coworker") {
			add("say(coworker){");
			add("  By the way, we'll be doing performance reviews when you're back, right?");
			add("}");
			
			add("say(player){");
			add("  Oh, I must've forgotten to say - I'm moving to a different division now.");
			add("}");
			
			add("delay(90)");
			
			add("say(player){");
			add("  Thanks so much - you're such a help!");
			add("}");
			
			add("delay(30)");
			
			add("say(coworker){");
			add("  Oh...ok...no problem...");
			add("}");
		}
		
		add("delay(90)");
		
		add("movecharacter(" + control.guest + ",doorright)");
		add("wait(movement)");
		add("movecharacter(" + control.guest + ",door)");
		add("wait(movement)");
		
		add("delay(30)");
		add("removecharacter(" + control.guest + ")");
		add("delay(10)");
		add("closedoor");
		
		if (control.guest == "ex") {	
			if (!control.insuitcase("bottle")) {
				add("face(player,up)");
				add("delay(90)");
				add("say(player){");
				add("  Bye, I guess.");
				add("}");
			}
		}
		add("textboxstyle(0)");
		
		//Cab, ending
		add("delay(120)");
		add("fadeout()");
		
		add("endingmusic()");
		
		add("wait(fade)");
		add("delay(60)");
		
		add("face(player,down)");
		add("fadein()");
		add("wait(fadein)");
		add("beephorn()");
		add("delay(30)");
		add("say(){");
		add("  Oh, that's my cab. Time to go.");
		add("}");
		add("delay(30)");
		
		add("movecharacter(player,suitcaseabove)");
		add("wait(movement)");
		add("face(player,up)");
		add("delay(20)");
		add("grabsuitcase()");
		add("delay(20)");
		
		add("movecharacter(player,door)");
		add("wait(movement)");
		
		add("delay(30)");
		add("opendoor");
		add("delay(60)");
		add("hideplayer");
		add("delay(60)");
		add("closedoor");
		
		add("delay(210)");
		add("endgame()");
	}else if (t == "spyending") {
		add("movecharacter(player,catcage)");
		add("wait(movement)");
		add("face(player,right)");
		
		add("delay(25)");
		add("say(){");
		add("  I'm sorry, Kitty. You know too much.");
		add("}");
		add("delay(30)");
		add("face(player,left)");
		add("aim()");
		add("delay(60)");
		add("fire()");
	}else if (t == "weirdendings") {
		add("face(player,down)");
		add("delay(30)");
		add("say(){");
		add("  Right. I'm out of here.");
		add("}");
		add("delay(30)");
		
		add("movecharacter(player,suitcaseabove)");
		add("wait(movement)");
		add("face(player,up)");
		add("delay(20)");
		add("grabsuitcase()");
		add("delay(20)");
		
		add("movecharacter(player,door)");
		add("wait(movement)");
		
		add("delay(30)");
		add("opendoor");
		add("delay(60)");
		add("hideplayer");
		add("delay(60)");
		add("closedoor");
		
		add("delay(210)");
		add("endgame()");
	}
	
	running = true;
}

public static function runscript():void {
	//Heart of the scripting engine: script commands implemented here
	while (running && scriptdelay <= 0 && !pausescript) {
		if (position < scriptlength) {
			//Let's split or command in an array of words
			tokenize(commands[position]);
			
			//Ok, now we run a command based on that string
			if (parsetext) {
				textbox.addline(help.trimspaces(words[0]));
			}else if (words[0] == "if") {
				//USAGE: if(flag,newscript);
				if (flag.istrue(words[1])) {
					load(words[2]); position--;
				}
			}else if (words[0] == "endif") {
				//USAGE: endif(flag);
				if (flag.istrue(words[1])) {
					position = scriptlength;
				}
			}else if (words[0] == "settrue") {
				flag.settrue(words[1]);
			}else if (words[0] == "setfalse") { 
				flag.setfalse(words[1]);
			}else if (words[0] == "delay") {
				//USAGE: delay(frames)
				scriptdelay = int(words[1]);
			}else if (words[0] == "flash") {
				//USAGE: flash(frames)
				gfx.flashlight = int(words[1]);
			}else if (words[0] == "shake") {
				//USAGE: shake(frames)
				gfx.screenshake = int(words[1]);
			}else if (words[0] == "fadeout") {
				gfx.fademode = def.FADE_OUT;
				gfx.fadeaction = def.FADEACTION_NOTHING
			}else if (words[0] == "fadein") {
				gfx.fademode = def.FADE_IN;
			}else if (words[0] == "changemap") {
				//USAGE: changemap("map
				obj.activedoordest = words[1];
				obj.doortox = int(words[2]);
				obj.doortoy = int(words[3]);
				
				gfx.fademode = def.FADE_OUT;
				gfx.fadeaction = def.FADEACTION_CHANGEROOM;
			}else if (words[0] == "wait") {
				//USAGE: wait(fade) - Wait until the screen is faded out
				if (words[1] == "fade") {
					if (gfx.fademode != def.FADED_OUT) {
						scriptdelay = 2; position--;
					}else {
						scriptdelay = 0;
					}
				}else if (words[1] == "fadein") {
					if (gfx.fademode != def.FADED_IN) {
						scriptdelay = 2; position--;
					}else {
						scriptdelay = 0;
					}
				}else if (words[1] == "trash") {
					if (control.chocolatemode > 0) {
						scriptdelay = 2; position--;
					}else if (control.trashlerp > 0) {
						scriptdelay = 2; position--;
					}else {
						scriptdelay = 0;
					}
				}else if (words[1] == "movement") {
					var t:int = 0;
					for (var i:int = 0; i < obj.nentity; i++) {
						if (obj.entities[i].active) {
							if (obj.entities[i].doscriptmove) {
								t = 1;
							}
						}
					}
					if (t > 0) {
						scriptdelay = 2; position--;
					}else {
						scriptdelay = 0;
					}
				}
			}else if (words[0] == "interal") {
				//USAGE: internal(functionname) - run function from gameclass
				game[words[1]]();
			}else if (words[0] == "say") {
				speaker = words[1];
				textbox.createtextbox("", -1, 0, textbox.col);
				parsetext = true;
			}else if (words[0] == "endsay") {
				//Prepare to speak a block of text
				if (speaker != "") {
					textbox.textboxposition(obj.getnpc(speaker));
				}else{
					textbox.textboxtopcenter();
				}
				textbox.starttextbox();
				parsetext = false;
				
				pausescript = true;
			}else if (words[0] == "textboxstyle") {
				//Change textbox style:
				textbox.col = int(words[1]);
			}else if (words[0] == "hideborders") {
				control.showborders = false;
			}else if (words[0] == "showborders") {
				control.showborders = true;
			}else if (words[0] == "highlight") {
				i = 0;
				if (words[1] == "off") {
					for (i = 0; i < control.numitems; i++) {
						control.items[i].highlight = false;
					}
				}else {
					i = control.itemindex[words[1]];
					if (i > -1) {
						control.items[i].highlight = true;
					}
				}
			}else if (words[0] == "changetopackingmode") {
				gfx.fademode = def.FADE_OUT;
				gfx.fadeaction = def.FADEACTION_PACKINGMODE;
			}else if (words[0] == "changetowalkabout_afterpacking") {
				control.suitcasepacked = true;
				gfx.fademode = def.FADE_OUT;
				gfx.fadeaction = def.FADEACTION_AFTERPACKING;
			}else if (words[0] == "changetotrashmode") {
				gfx.fademode = def.FADE_OUT;
				gfx.fadeaction = def.FADEACTION_TRASHMODE;
			}else if (words[0] == "endgame") {
				gfx.fademode = def.FADE_OUT;
				gfx.fadeaction = def.FADEACTION_GAMEOVER;
			}else if (words[0] == "trash") {
				control.trashitem(control.itemindex[words[1]]);
			}else if (words[0] == "changetowalkabout_aftertrash") {
				control.everythingtrashed = true;
				control.carryingtrash = false;
				gfx.fademode = def.FADE_OUT;
				gfx.fadeaction = def.FADEACTION_AFTERTRASH;
				control.emptysuitcase();
			}else if (words[0] == "opendoor") {
				control.dooropened = true;
				music.playef("dooropen");
			}else if (words[0] == "closedoor") {
				if (map.levelimg == -1) {
					music.playef("doorclose");
				}
				control.dooropened = false;
			}else if (words[0] == "movecharacter") {
				t = 0;
				if (words[1] == "player") {
					t = 0;
				}else {
					t = obj.getperson(words[1]);
				}
				if (t >= 0) {
					obj.entities[t].doscriptmove = true;
					if (words[2] == "catcage") {
						obj.entities[t].scriptmovedestx = 184;
						obj.entities[t].scriptmovedesty = 176;
					}else if (words[2] == "suitcaseleft") {
						obj.entities[t].scriptmovedestx = 150;
						obj.entities[t].scriptmovedesty = 156;
					}else if (words[2] == "suitcaseright") {
						obj.entities[t].scriptmovedestx = 216;
						obj.entities[t].scriptmovedesty = 156;
					}else if (words[2] == "catcageleft") {
						obj.entities[t].scriptmovedestx = 150;
						obj.entities[t].scriptmovedesty = 176;
					}else if (words[2] == "catcageright") {
						obj.entities[t].scriptmovedestx = 216;
						obj.entities[t].scriptmovedesty = 176;
					}else if (words[2] == "door") {
						obj.entities[t].scriptmovedestx = 184;
						obj.entities[t].scriptmovedesty = 96;
					}else if (words[2] == "suitcaseabove") {
						obj.entities[t].scriptmovedestx = 184;
						obj.entities[t].scriptmovedesty = 125; 
					}else if (words[2] == "doorleft") {
						obj.entities[t].scriptmovedestx = 150;
						obj.entities[t].scriptmovedesty = 125;
					}else if (words[2] == "doorright") {
						obj.entities[t].scriptmovedestx = 216;
						obj.entities[t].scriptmovedesty = 125;
					}else{
						obj.entities[t].scriptmovedestx = int(words[2]);
						obj.entities[t].scriptmovedesty = int(words[3]);
					}
				}
			}else if (words[0] == "face") {
				if (words[1] == "player") {
					obj.entities[0].dir = control.persondir(words[2]);
				}else {
					t = obj.getperson(words[1]);
					if (t > 0) {
						obj.entities[t].dir = control.persondir(words[2]);
					}
				}
			}else if (words[0] == "addcharacter") {
				if (words[2] == "catcage") {
					obj.createentity(184,176, "person", words[1]);
				}else if (words[2] == "suitcaseleft") {
					obj.createentity(150,156, "person", words[1]);
				}else if (words[2] == "suitcaseright") {
					obj.createentity(216,156, "person", words[1]);
				}else if (words[2] == "catcageleft") {
					obj.createentity(150,176, "person", words[1]);
				}else if (words[2] == "catcageright") {
					obj.createentity(216,176, "person", words[1]);
				}else if (words[2] == "door") {
					obj.createentity(184,96, "person", words[1]);
				}else if (words[2] == "suitcaseabove") {
					obj.createentity(184,125, "person", words[1]);
				}else if (words[2] == "doorleft") {
					obj.createentity(150,125, "person", words[1]);
				}else if (words[2] == "doorright") {
					obj.createentity(216,125, "person", words[1]);
				}else{
					obj.createentity(int(words[2]), int(words[3]), "person", words[1]);
				}
			}else if (words[0] == "removecharacter") {
				t = obj.getperson(words[1]);
				if (t > 0) {
					obj.entities[t].active = false;
				}
			}else if (words[0] == "hideplayer") {
				control.showplayer = false;
			}else if (words[0] == "getcatcage") {
				control.carryingcatcage = true;
				control.catcollected = true;
				music.playef("catgoodbye")
			}else if (words[0] == "grabsuitcase") {
				control.carryingsuitcase = true;
			}else if (words[0] == "beephorn") {
				music.playef("carbeep")
			}else if (words[0] == "aim") {
				control.aim = true;
			}else if (words[0] == "fire") {
				music.playef("pistol");
				gfx.fademode = def.FADE_OUT;
				gfx.fadeaction = def.FADEACTION_GAMEOVER;
			}else if (words[0] == "undress") {
				music.playef("drop_item_in_bin_2");
				control.naked = true;
			}else if (words[0] == "endingmusic") {
				if (control.insuitcase("ukelele")) {
					music.play("endinguke");
				}else{
					music.play("endingnouke");
				}
			}
			
			position++;
		}else {
			running = false;
		}
	}
	
	if(scriptdelay>0){
		scriptdelay--;
	}
}