import com.terry.engine.*;
import gamecontrol.draw;

//Gfxclass functions that define the basic style of the game go here
//For example: What fades look like, what textboxes look like, flashes and shakes, etc.
//In theory, you should never have to modify any code in com.terry.engine

public static function drawfade():void {
	if (fademode == 1) {
		backbuffer.fillRect(backbuffer.rect, 0x000000);
	}else if (fademode == 3) {
		for (var j:int = 0; j < 12; j++) {
			if (j % 2 == 0) {
				fillrect(-10, j * 20, 10+(fadeamount * (def.SCREENWIDTH)) / 100, 20, 0, 0, 0);
			}else {
				fillrect(gfx.screenwidth - ((fadeamount * (def.SCREENWIDTH)) / 100), j * 20, ((fadeamount * (def.SCREENWIDTH)) / 100)+10, 20, 0, 0, 0);
			}
		}
	}else if (fademode == 5) {
		for (j = 0; j < 12; j++) {
			if (j % 2 == 0) {
				fillrect(-10, j * 20, 10+(fadeamount * (def.SCREENWIDTH)) / 100, 20, 0, 0, 0);
			}else {
				fillrect(gfx.screenwidth - ((fadeamount * (def.SCREENWIDTH)) / 100), j * 20, ((fadeamount * (def.SCREENWIDTH)) / 100)+10, 20, 0, 0, 0);
			}
		}
	}
}
		
public static function textboxcol(type:int, shade:int):int {
	//Color lookup function for textboxes
	switch(type) {
		case 0: //White textbox
			switch(shade) {
				case 0: return RGB(0, 0, 0); break;
				case 1: return RGB(255, 255, 255); break;
				case 2: return RGB(192, 192, 192); break;
			}
		break;
		case 1: //Red textbox
			switch(shade) {
				case 0: return RGB(0, 0, 0); break;
				case 1: return RGB(65, 3, 19); break;
				case 2: return RGB(255, 31, 41); break;
			}
		break;
		case 2: //Green textbox
			switch(shade) {
				case 0: return RGB(0, 0, 0); break;
				case 1: return RGB(3, 65, 5); break;
				case 2: return RGB(31, 255, 84); break;
			}
		break;
		case 3: //Blue textbox
			switch(shade) {
				case 0: return RGB(0, 0, 0); break;
				case 1: return RGB(3, 37, 65); break;
				case 2: return RGB(31, 105, 255); break;
			}
		break;
		
	}
	return RGB(0, 0, 0);
}

public static function drawtextbox(xp:int, yp:int, w:int, h:int, col:int, a:Number):void {
	//Draw a textbox at given position and size with alpha a, color col
	if (col == 0) {
		col = (3 * int((help.glow % 64) / 16));
		gfx.drawtilealpha(xp - 16, yp + h - 6, 432, a);
		gfx.drawtilealpha(xp - 8, yp + h - 12, 432, a);
		textbubblex = -1;
	}else if (col == 1) {
		col = 13;
		textbubblex = -1;
	}else if (col == 2) {
		col = 13;
		a = 1.0;
	}
	
	xp -= 4;
	yp -= 4;
	h = h / 16;
	w = w / 16;
	for (var j:int = 0; j < h; j++) {
		for (var i:int = 0; i < w; i++) {
			if (j == 0) {
				//Top edge
				if (i == 0) {
					gfx.drawtilealpha(xp, yp, 420 + col, a);
				}else if (i == w - 1) {
					gfx.drawtilealpha(xp + (i * 16), yp, 422 + col, a);
				}else {
					gfx.drawtilealpha(xp + (i * 16), yp, 421 + col, a);
				}
			}else if (j == h - 1) {
				//Bottom edge
				if (i == 0) {
					if (textbubblex > 0) {
						gfx.drawtilealpha(xp, yp + (j * 16), 460 + col - 21, a);
					}else{
						gfx.drawtilealpha(xp, yp + (j * 16), 460 + col, a);
					}
				}else if (i == w - 1) {
					gfx.drawtilealpha(xp + (i * 16), yp + (j * 16), 462 + col, a);
				}else {
					if (i == w - 2 && textbubblex > i) {
						gfx.drawtilealpha(xp + (i * 16), yp + (j * 16), 461 + col - 2, a);
					}else if (textbubblex == i) {
						gfx.drawtilealpha(xp + (i * 16), yp + (j * 16), 461 + col - 2, a);
					}else{
						gfx.drawtilealpha(xp + (i * 16), yp + (j * 16), 461 + col, a);
					}
				}
			}else{
				//Middle
				if (i == 0) {
					gfx.drawtilealpha(xp, yp + (j * 16), 440 + col, a);
				}else if (i == w - 1) {
					gfx.drawtilealpha(xp + (i * 16), yp + (j * 16), 442 + col, a);
				}else {
					gfx.drawtilealpha(xp + (i * 16), yp + (j * 16), 441 + col, a);
				}
			}
		}
	}
	/*
	alphamult = 0xFF * a;
	
	settrect(0, 0, w, h - 32); textboxbuffer.fillRect(trect, textboxcol(col, 1));
	settrect(0, 0, 2, h - 32); textboxbuffer.fillRect(trect, textboxcol(col, 0));
	settrect(w - 2, 0, 2, h - 32); textboxbuffer.fillRect(trect, textboxcol(col, 0));
	settrect(2, 0, 2, h - 32); textboxbuffer.fillRect(trect, textboxcol(col, 2));	
	settrect(w - 4, 0, 2, h - 32); textboxbuffer.fillRect(trect, textboxcol(col, 2));	
	
	settrect(0, 0, w, h - 32);	settpoint(xp, yp + 16); 
	backbuffer.merge(textboxbuffer, trect, tpoint, alphamult, alphamult, alphamult, alphamult);
	
	settrect(0, 0, w - 32, 16); textboxbuffer.fillRect(trect, textboxcol(col, 1));
	settrect(0, 0, w - 32, 2); textboxbuffer.fillRect(trect, textboxcol(col, 0));
	settrect(0, 2, w - 32, 2); textboxbuffer.fillRect(trect, textboxcol(col, 2));
	
	settrect(0, 0, w - 32, 16);	settpoint(xp + 16, yp); 
	backbuffer.merge(textboxbuffer, trect, tpoint, alphamult, alphamult, alphamult, alphamult);
	
	settrect(0, 0, w - 32, 16); textboxbuffer.fillRect(trect, textboxcol(col, 1));		
	settrect(0, 14, w -32, 2); textboxbuffer.fillRect(trect, textboxcol(col, 0));
	settrect(0, 12, w - 32, 2); textboxbuffer.fillRect(trect, textboxcol(col, 2));
	
	settrect(0, 0, w - 32, 16);	settpoint(xp + 16, yp + h - 16); 
	backbuffer.merge(textboxbuffer, trect, tpoint, alphamult, alphamult, alphamult, alphamult);
	
	//Draw edges
	settrect(xp, yp, 16, 16); temptile.copyPixels(backbuffer, trect, tl);
	temptile.merge(tbsides[(col * 4) + 0], tbsides_rect, tl, alphamult, alphamult, alphamult, alphamult);	temptile.floodFill(0, 0, 0);
	settpoint(xp, yp); backbuffer.copyPixels(temptile, temptile.rect, tpoint);
	
	settrect(xp + w - 16, yp, 16, 16); temptile.copyPixels(backbuffer, trect, tl);
	temptile.merge(tbsides[(col * 4) + 1], tbsides_rect, tl, alphamult, alphamult, alphamult, alphamult);	temptile.floodFill(15, 0, 0);
	settpoint(xp + w - 16, yp); backbuffer.copyPixels(temptile, temptile.rect, tpoint);
	
	settrect(xp, yp + h - 16, 16, 16); temptile.copyPixels(backbuffer, trect, tl);
	temptile.merge(tbsides[(col * 4) + 2], tbsides_rect, tl, alphamult, alphamult, alphamult, alphamult);	temptile.floodFill(0, 15, 0);
	settpoint(xp, yp + h - 16); backbuffer.copyPixels(temptile, temptile.rect, tpoint);
	
	settrect(xp + w - 16, yp + h - 16, 16, 16); temptile.copyPixels(backbuffer, trect, tl);
	temptile.merge(tbsides[(col * 4) + 3], tbsides_rect, tl, alphamult, alphamult, alphamult, alphamult);	temptile.floodFill(15, 15, 0);
	settpoint(xp + w - 16, yp + h - 16); backbuffer.copyPixels(temptile, temptile.rect, tpoint);
	*/
}

public static function clicktostart():void {
	gfx.fillrect(0,0,gfx.screenwidth, gfx.screenheight,31, 44, 65);
	print(5, 110-5, "Use MOUSE to play", 71, 145, 244, true);
	print(5, 120+5, "Click to start", 71, 145, 244, true);
}

public static function outoffocusrender():void {
	fillrect(0, 100, 384, 38, 0, 0, 0);
	bigprint(5, 105-6, "Game paused", 255 - (help.glow/2), 255 - (help.glow/2), 255 - (help.glow/2), true);
	print(5, 125-3, "[click to resume]", 196 - (help.glow/2), 196 - (help.glow/2), 196 - (help.glow/2), true);
	fillrect(0, 228, 384, 12, 0, 0, 0);
	print(5, 230-3, "Press M to mute", 255 - (help.glow/2), 255 - (help.glow/2), 255 - (help.glow/2), true);
	normalrender();
}

public static function gfxflashlight():void {
	backbuffer.fillRect(backbuffer.rect, 0xFFFFFF);
}

public static function gfxscreenshake():void {
	screenbuffer.lock();
	screenbuffer.copyPixels(backbuffer, backbuffer.rect, tl, null, null, false);
	settpoint((Math.random() * 5) - 3, (Math.random() * 5) - 3);
	screenbuffer.copyPixels(backbuffer, backbuffer.rect, tpoint, null, null, false);
	screenbuffer.unlock();
	
	backbuffer.lock();
	backbuffer.fillRect(backbuffer.rect, 0x000000);
	backbuffer.unlock();
}