package gamecontrol {
	import flash.display.*;
	import flash.geom.*;
  import flash.events.*;
  import flash.net.*;
	import com.terry.engine.*;
	
	public class draw {
	  public static function init():void {
			
		}
		
		public static function drawparticles():void {			
			for (var i:int = 0; i < obj.nparticles; i++) {
				if (obj.particles[i].active) {
					if (obj.particles[i].type == "pixel") {
						gfx.settrect(obj.particles[i].xp - map.camerax, obj.particles[i].yp - map.cameray, 5, 5);
						gfx.backbuffer.fillRect(gfx.trect, gfx.RGB(255, 255, 255));
					}else if (obj.particles[i].type == "rpgtext") {
						//White text
						font.print(obj.particles[i].xp - map.camerax, obj.particles[i].yp - map.cameray, 
											 String(obj.particles[i].colour), 255, 255, 255);
					}else {
						gfx.settpoint(obj.particles[i].xp - map.camerax, obj.particles[i].yp - map.cameray);
						gfx.backbuffer.copyPixels(gfx.sprites[obj.particles[i].tile], gfx.sprites_rect, gfx.tpoint);
					}
				}
			}
		}
		
		public static function drawmap():void {
			if (map.noxcam) map.camerax = 0; if (map.noycam) map.cameray = 0;
			
			for (var j:int = 0; j < 15; j++) {
				for (var i:int = 0; i < 25; i++) {
					if (map.at(i, j, map.camerax, map.cameray) > 0) {
						gfx.drawtile((i * def.TILESIZE) - (map.camerax % def.TILESIZE), (j * def.TILESIZE) - (map.cameray % def.TILESIZE), map.at(i, j, map.camerax, map.cameray));
					}
				}
			}
			
			if (control.dooropened) {
				if (!game.running && help.inboxw(mouse.x / 2, mouse.y / 2, 11 * 16, 3 * 16, 32, 3 * 16)) {
					control.showactionmessage(control.exitname);
					if (help.slowsine % 32 > 16) {
						draw.drawtilegrid(11 * 16, 3 * 16, 10, 20, 2, 1);	
						draw.drawtilegrid(11 * 16, 4 * 16, 12, 20, 2, 1);	
						draw.drawtilegrid(11 * 16, 5 * 16, 14, 20, 2, 1);	
					}else {
						draw.drawtilegrid(11*16, 3*16, 18, 35, 2, 3);	
					}
				}else{
					draw.drawtilegrid(11*16, 3*16, 18, 35, 2, 3);	
				}
			}else{
				if (!game.running && help.inboxw(mouse.x / 2, mouse.y / 2, 11 * 16, 3 * 16, 32, 3 * 16)) {
					control.showactionmessage(control.exitname);
					if (help.slowsine % 32 > 16) {
						draw.drawtilegrid(11 * 16, 3 * 16, 10, 19, 2, 1);	
						draw.drawtilegrid(11 * 16, 4 * 16, 12, 19, 2, 1);	
						draw.drawtilegrid(11 * 16, 5 * 16, 14, 19, 2, 1);	
					}else {
						draw.drawtilegrid(11*16, 3*16, 1, 24, 2, 3);	
					}
				}else{
					draw.drawtilegrid(11*16, 3*16, 1, 24, 2, 3);	
				}
			}
		}
		
		public static function drawbackground():void {
			for (var j:int = 0; j < 26; j++) {
				for (var i:int = 0; i < 25; i++) {
					gfx.drawtile(i * def.TILESIZE, (j * 10)-4, 340 + (i % 4) + ((j % 2) * 20));
				}
			}
		}
		
		public static function drawtilegrid(xp:int, yp:int, x:int, y:int, w:int, h:int):void {
			for (var j:int = 0; j < h; j++) {
				for (var i:int = 0; i < w; i++) {
					gfx.drawtile(xp + (i * def.TILESIZE), yp + (j * def.TILESIZE), (x + (y * 20)) + i + (j * 20));
				}
			}
		}
		
		public static function smallborder(t:int):void {
			gfx.drawbox(control.items[t].position.x, control.items[t].position.y, ((control.items[t].size.x) * def.TILESIZE), ((control.items[t].size.y) * def.TILESIZE), 255, 255, 255);
		}
		
		public static function highlightborder(t:int):void {
			for (var j:int = 0; j < control.items[t].size.y; j++) {
				for (var i:int = 0; i < control.items[t].size.x; i++) {
					if ((help.slowsine % 32 > 16)) {
						gfx.drawtile(control.items[t].position.x + (i * def.TILESIZE), control.items[t].position.y + (j * def.TILESIZE), 344 + int((help.slowsine % 32) / 8));
					}else{
						gfx.drawtile(control.items[t].position.x + (i * def.TILESIZE), control.items[t].position.y + (j * def.TILESIZE), 248 + int((help.slowsine % 32) / 8));
					}
				}
			}
		}
		
		public static function drawborder(t:int):void {
			//Background tiles
			var i:int, j:int;
			/*
			for (j = 0; j < control.items[t].size.y; j++) {
				for (i = 0; i < control.items[t].size.x; i++) {
					gfx.drawtile(control.items[t].position.x + (i * def.TILESIZE), control.items[t].position.y + (j * def.TILESIZE), 248 + int((help.slowsine % 32) / 8));
				}
			}
			*/
			//Top left
			gfx.drawtile(control.items[t].position.x-5, control.items[t].position.y-5, 16);
			//Top Right
			gfx.drawtile(control.items[t].position.x + ((control.items[t].size.x-1) * def.TILESIZE) + 5, control.items[t].position.y-5, 17);
			//Bottom Left
			gfx.drawtile(control.items[t].position.x-5, control.items[t].position.y + ((control.items[t].size.y-1) * def.TILESIZE) + 5, 18);
			//Bottom Right
			gfx.drawtile(control.items[t].position.x + ((control.items[t].size.x-1) * def.TILESIZE) + 5, control.items[t].position.y + ((control.items[t].size.y-1) * def.TILESIZE) + 5, 19);
			
			//Left and Right
			for (j = 0; j < control.items[t].size.y; j++) {
				gfx.drawtile(control.items[t].position.x - 4, control.items[t].position.y + (j * def.TILESIZE), 78);
				gfx.drawtile(control.items[t].position.x + 4 + ((control.items[t].size.x-1) * def.TILESIZE), control.items[t].position.y + (j * def.TILESIZE), 98);
			}
			
			//Text
			if (gfx.len(control.items[t].printedname) + control.items[t].position.x + 4 + ((control.items[t].size.x) * def.TILESIZE) > def.SCREENWIDTH) {
				control.highlighttext = control.items[t].printedname;
				control.highlighttext_xp = control.items[t].position.x - 8 - gfx.len(control.items[t].printedname);
				control.highlighttext_yp = control.items[t].position.y - 6;
			}else {
				control.highlighttext = control.items[t].printedname;
				control.highlighttext_xp = control.items[t].position.x + 4 + ((control.items[t].size.x) * def.TILESIZE);
				control.highlighttext_yp = control.items[t].position.y - 6;
			}
		}
		
		public static function drawbinborder(t:int):void {
			if(help.slowsine%16>8){
				draw.drawtilegrid(def.SCREENWIDTH - (3 * def.TILESIZE), def.SCREENHEIGHT - (4 * def.TILESIZE), 10, 13, 2, 3);
			}else {
				draw.drawtilegrid(def.SCREENWIDTH - (3 * def.TILESIZE), def.SCREENHEIGHT - (4 * def.TILESIZE), 10, 5, 2, 3);
			}
		}
		
		public static function borderprint(x:int, y:int, t:String, r:int, g:int, b:int):void {
			gfx.print(x - 1, y - 1, t, 0, 0, 0);
			gfx.print(x + 1, y - 1, t, 0, 0, 0);
			
			gfx.print(x - 1, y, t, 0, 0, 0);
			gfx.print(x + 1, y, t, 0, 0, 0);
			
			gfx.print(x - 1, y + 1, t, 0, 0, 0);
			gfx.print(x + 1, y + 1, t, 0, 0, 0);
			
			
			gfx.print(x, y, t, r, g, b);
		}
		
		public static function bigborderprint(x:int, y:int, t:String, r:int, g:int, b:int, sz:int=2):void {
			gfx.bigprint(x - 1, y - 1, t, 0, 0, 0, true, sz);
			gfx.bigprint(x + 1, y - 1, t, 0, 0, 0, true, sz);
			
			gfx.bigprint(x - 1, y, t, 0, 0, 0, true, sz);
			gfx.bigprint(x + 1, y, t, 0, 0, 0, true, sz);
			
			gfx.bigprint(x - 1, y + 1, t, 0, 0, 0, true, sz);
			gfx.bigprint(x + 1, y + 1, t, 0, 0, 0, true, sz);
			
			
			gfx.bigprint(x, y, t, r, g, b, true, sz);
		}
		
		public static function cat(i:int):void {
			if(control.catstate=="sleeping"){
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, control.items[i].tile + (control.catframe) * 2, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "bothered1") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 28, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "bothered2") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 28 + (control.catframe) * 2, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "bothered3") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 28, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "bothered4") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 32, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "bothered5") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 34, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "bothered6") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 36, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "bothered7") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 60 + (control.catframe) * 2, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "bothered8") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 36, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "sitdown1") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 36, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "sitdown2") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 34, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "sitdown3") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 32, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "sitdown4") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 30, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "sitdown5") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 26, 0, control.items[i].size.x, control.items[i].size.y);	
			}else if (control.catstate == "sitdown6") {
				drawtilegrid(control.items[i].position.x, control.items[i].position.y, 24, 0, control.items[i].size.x, control.items[i].size.y);	
			}
		}
		
		public static function miniluggage():void {
			//Draw a mini version of the luggage at half positions, centered on screen
			if (!control.suitcasepacked) {
				for (var i:int = control.numitems - 1; i >= 0; i--) {
					if (control.items[i].name == "sunflower") {
						//draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth/6)) + (control.items[i].position.x/3), gfx.screenheightmid - (gfx.screenheight/6) + (control.items[i].position.y/3)-10, control.items[i].minitile, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
					}else if (control.items[i].usedingame && control.items[i].name != "cat") {
						if ((gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3) < gfx.screenwidthmid) {
							draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth/6)) + (control.items[i].position.x/3), gfx.screenheightmid - (gfx.screenheight/6) + (control.items[i].position.y/3)+24, control.items[i].minitile, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
						}else {
							draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth/6)) + (control.items[i].position.x/3), gfx.screenheightmid - (gfx.screenheight/6) + (control.items[i].position.y/3)+32, control.items[i].minitile, 0, control.items[i].minisize.x, control.items[i].minisize.y);		
						}
					}
				}
			}
			
			//Draw Sunflower
			i = control.itemindex["sunflower"];
			if(!control.items[i].trashed){
				if (!game.running && help.inboxw(mouse.x / 2, mouse.y / 2, (gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) - 10, 16, 4 * 16)) {
					control.showactionmessage(control.flowername);
					if (help.slowsine % 32 > 16) {
						draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) - 10, control.items[i].minitile, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
					}else {
						draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) - 10, control.items[i].minitile-5, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
					}
				}else{
					draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) - 10, control.items[i].minitile, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
				}
			}
			
			//Draw luggage
			if (control.suitcasepacked) {
				if(!control.carryingsuitcase){
					if (!game.running && help.inboxw(mouse.x / 2, mouse.y / 2, gfx.screenwidthmid - 16, gfx.screenheightmid - 16 + 32, 32, 32)) {
						control.showactionmessage(control.suitcasename);
						if (help.slowsine % 32 > 16) {
							draw.drawtilegrid(gfx.screenwidthmid - 16, gfx.screenheightmid - 16 + 32, 18, 19, 2, 2);			
						}else {
							draw.drawtilegrid(gfx.screenwidthmid - 16, gfx.screenheightmid - 16 + 32, 16, 19, 2, 2);			
						}
					}else{
						draw.drawtilegrid(gfx.screenwidthmid - 16, gfx.screenheightmid - 16 + 32, 16, 19, 2, 2);			
					}
				}
			}else{
				if (!game.running && help.inboxw(mouse.x / 2, mouse.y / 2, gfx.screenwidthmid - 16, gfx.screenheightmid - 16 + 32, 32, 32)) {
					control.showactionmessage(control.suitcasename);
					if (help.slowsine % 32 > 16) {
						draw.drawtilegrid(gfx.screenwidthmid - 16, gfx.screenheightmid - 16 + 32, 486+90, 0, 2, 2);			
					}else {
						draw.drawtilegrid(gfx.screenwidthmid - 16, gfx.screenheightmid - 16 + 32, 486, 0, 2, 2);			
					}
				}else{
					draw.drawtilegrid(gfx.screenwidthmid - 16, gfx.screenheightmid - 16 + 32, 486, 0, 2, 2);			
				}
			}
			
			//Draw cat
			
			if (control.catpacked) {
				if(!control.catcollected){
					draw.drawtilegrid(gfx.screenwidthmid - 8, gfx.screenheightmid - 16 - 4 + 32 + 32 + 6, 575, 0, 1, 1);
				}
			}else{
				i = control.itemindex["cat"];
				draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) +32, control.items[i].minitile+1, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
				if (!game.running && help.inboxw(mouse.x / 2, mouse.y / 2, (gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) +32 - 4, 16, 16)) {
					control.showactionmessage(control.catname);
					if (help.slowsine % 32 > 16) {
						draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) +32 - 4, control.items[i].minitile-20+1, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
					}else {
						draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) +32 - 4, control.items[i].minitile, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
					}
				}else {
					draw.drawtilegrid((gfx.screenwidthmid - (gfx.screenwidth / 6)) + (control.items[i].position.x / 3), gfx.screenheightmid - (gfx.screenheight / 6) + (control.items[i].position.y / 3) +32 - 4, control.items[i].minitile, 0, control.items[i].minisize.x, control.items[i].minisize.y);	
				}
				
				//Draw cat cage
				if (!game.running && !control.bininflat && help.inboxw(mouse.x / 2, mouse.y / 2, gfx.screenwidthmid - 16 + 64, gfx.screenheightmid - 16 + 32 + 32+6, 16, 16)) {
					control.showactionmessage(control.cagename);
					if (help.slowsine % 32 > 16) {
						draw.drawtilegrid(gfx.screenwidthmid - 16+64, gfx.screenheightmid - 16 + 32+32+6, 575, 0, 1, 1);
					}else {
						draw.drawtilegrid(gfx.screenwidthmid - 16+64, gfx.screenheightmid - 16 + 32+32+6, 575+20, 0, 1, 1);
					}
				}else {
					draw.drawtilegrid(gfx.screenwidthmid - 16+64, gfx.screenheightmid - 16 + 32+32+6, 575, 0, 1, 1);
				}
			}
			
			//Draw bin
			if(control.bininflat){
				if (!game.running && help.inboxw(mouse.x / 2, mouse.y / 2, gfx.screenwidthmid - 16 + 64, gfx.screenheightmid - 16 + 32 + 32, 16, 32)) {
					control.showactionmessage(control.binname);
					if (help.slowsine % 32 > 16) {
						draw.drawtilegrid(gfx.screenwidthmid - 16+64, gfx.screenheightmid - 16 + 32+32, 519, 0, 1, 2);
					}else {
						draw.drawtilegrid(gfx.screenwidthmid - 16+64, gfx.screenheightmid - 16 + 32+32, 519+40, 0, 1, 2);
					}
				}else {
					draw.drawtilegrid(gfx.screenwidthmid - 16+64, gfx.screenheightmid - 16 + 32+32, 519, 0, 1, 2);
				}
			}
		}
	}
}