import com.terry.engine.*;
import objs.*;

//Embedded resources:		
[Embed(source = '../data/graphics/tiles.png')]	private var im_tiles:Class;
//Full images
[Embed(source = '../data/graphics/outside_cold.png')]	private var im_image0:Class;
[Embed(source = '../data/graphics/outside_warm.png')]	private var im_image1:Class;
[Embed(source = '../data/graphics/outside_future.png')]	private var im_image2:Class;
[Embed(source = '../data/graphics/menu1.png')]	private var im_image3:Class;
[Embed(source = '../data/graphics/menu2.png')]	private var im_image4:Class;
[Embed(source = '../data/graphics/menu3.png')]	private var im_image5:Class;

[Embed(source = '../data/graphics/car1.png')]	private var im_image6:Class;
[Embed(source = '../data/graphics/car2.png')]	private var im_image7:Class;
[Embed(source = '../data/graphics/car3.png')]	private var im_image8:Class;
[Embed(source = '../data/graphics/car4.png')]	private var im_image9:Class;
[Embed(source = '../data/graphics/car5.png')]	private var im_image10:Class;
[Embed(source = '../data/graphics/car6.png')]	private var im_image11:Class;
[Embed(source = '../data/graphics/car7.png')]	private var im_image12:Class;
//Music
[Embed(source = '../data/music/01_titlescreen.mp3')]	private var music_0:Class;
[Embed(source = '../data/music/02_initialapartment.mp3')]	private var music_1:Class;
[Embed(source = '../data/music/03_packing.mp3')]	private var music_2:Class;
[Embed(source = '../data/music/04_packingreview.mp3')]	private var music_3:Class;
[Embed(source = '../data/music/05_outdoors.mp3')]	private var music_4:Class;
[Embed(source = '../data/music/06_throwingouttrash.mp3')]	private var music_5:Class;
[Embed(source = '../data/music/07_cat.mp3')]	private var music_6:Class;
[Embed(source = '../data/music/08_endingnouke.mp3')]	private var music_7:Class;
[Embed(source = '../data/music/09_endinguke.mp3')]	private var music_8:Class;
[Embed(source = '../data/music/10_endingspy.mp3')]	private var music_9:Class;
[Embed(source = '../data/music/11_endingweird.mp3')]	private var music_10:Class;
//Sound effects
[Embed(source = '../data/sounds/bag_mode_enter.mp3')]	private var ef_0:Class;
[Embed(source = '../data/sounds/cannot_place_item.mp3')]	private var ef_1:Class;
[Embed(source = '../data/sounds/cannot_place_item_2.mp3')]	private var ef_2:Class;
[Embed(source = '../data/sounds/carbeep.mp3')]	private var ef_3:Class;
[Embed(source = '../data/sounds/cat_put_in_bag.mp3')]	private var ef_4:Class;
[Embed(source = '../data/sounds/cat_put_in_bin.mp3')]	private var ef_5:Class;
[Embed(source = '../data/sounds/catgoodbye.mp3')]	private var ef_6:Class;
[Embed(source = '../data/sounds/catlick.mp3')]	private var ef_7:Class;
[Embed(source = '../data/sounds/catmeow1.mp3')]	private var ef_8:Class;
[Embed(source = '../data/sounds/catmeow2.mp3')]	private var ef_9:Class;
[Embed(source = '../data/sounds/catpickup.mp3')]	private var ef_10:Class;
[Embed(source = '../data/sounds/catpickup2.mp3')]	private var ef_11:Class;
[Embed(source = '../data/sounds/catpurr.mp3')]	private var ef_12:Class;
[Embed(source = '../data/sounds/close_bag.mp3')]	private var ef_13:Class;
[Embed(source = '../data/sounds/close_cage.mp3')]	private var ef_14:Class;
[Embed(source = '../data/sounds/doorknock.mp3')]	private var ef_15:Class;
[Embed(source = '../data/sounds/dooropen.mp3')]	private var ef_16:Class;
[Embed(source = '../data/sounds/drop_item_in_bag.mp3')]	private var ef_17:Class;
[Embed(source = '../data/sounds/drop_item_in_bin.mp3')]	private var ef_18:Class;
[Embed(source = '../data/sounds/drop_item_in_bin_2.mp3')]	private var ef_19:Class;
[Embed(source = '../data/sounds/pistol.mp3')]	private var ef_20:Class;
[Embed(source = '../data/sounds/floorboardsqueak_1.mp3')]	private var ef_21:Class;
[Embed(source = '../data/sounds/floorboardsqueak_2.mp3')]	private var ef_22:Class;
[Embed(source = '../data/sounds/sadcat1.mp3')]	private var ef_23:Class;
[Embed(source = '../data/sounds/sadcat2.mp3')]	private var ef_24:Class;
[Embed(source = '../data/sounds/take_item_from_bag.mp3')]	private var ef_25:Class;
[Embed(source = '../data/sounds/take_item_from_floor.mp3')]	private var ef_26:Class;
[Embed(source = '../data/sounds/text_window_changes.mp3')]	private var ef_27:Class;
[Embed(source = '../data/sounds/text_window_closes.mp3')]	private var ef_28:Class;
[Embed(source = '../data/sounds/text_window_opens.mp3')]	private var ef_29:Class;
[Embed(source = '../data/sounds/title_screen_select.mp3')]	private var ef_30:Class;
[Embed(source = '../data/sounds/title_screen_selection_change.mp3')]	private var ef_31:Class;
[Embed(source = '../data/sounds/traffic1.mp3')]	private var ef_32:Class;
[Embed(source = '../data/sounds/traffic2.mp3')]	private var ef_33:Class;
[Embed(source = '../data/sounds/traffic3.mp3')]	private var ef_34:Class;
[Embed(source = '../data/sounds/doorclose.mp3')]	private var ef_35:Class;

public function loadresources():void {
	//Load Music
  music.musicchan.push(new music_0());
  music.musicchan.push(new music_1());
  music.musicchan.push(new music_2());
  music.musicchan.push(new music_3());
  music.musicchan.push(new music_4());
  music.musicchan.push(new music_5());
  music.musicchan.push(new music_6());
  music.musicchan.push(new music_7());
  music.musicchan.push(new music_8());
  music.musicchan.push(new music_9());
  music.musicchan.push(new music_10());
	music.addsong("titlescreen");
	music.addsong("initialapartment");
	music.addsong("packing");
	music.addsong("packingreview");
	music.addsong("outdoors");
	music.addsong("throwingouttrash");
	music.addsong("cat");
	music.addsong("endingnouke");
	music.addsong("endinguke");
	music.addsong("endingspy");
	music.addsong("endingweird");
	
	//Load Soundeffects
  music.efchan.push(new ef_0());
  music.efchan.push(new ef_1());
  music.efchan.push(new ef_2());
  music.efchan.push(new ef_3());
  music.efchan.push(new ef_4());
  music.efchan.push(new ef_5());
  music.efchan.push(new ef_6());
  music.efchan.push(new ef_7());
  music.efchan.push(new ef_8());
  music.efchan.push(new ef_9());
  music.efchan.push(new ef_10());
  music.efchan.push(new ef_11());
  music.efchan.push(new ef_12());
  music.efchan.push(new ef_13());
  music.efchan.push(new ef_14());
  music.efchan.push(new ef_15());
  music.efchan.push(new ef_16());
  music.efchan.push(new ef_17());
  music.efchan.push(new ef_18());
  music.efchan.push(new ef_19());
  music.efchan.push(new ef_20());
  music.efchan.push(new ef_21());
  music.efchan.push(new ef_22());
  music.efchan.push(new ef_23());
  music.efchan.push(new ef_24());
  music.efchan.push(new ef_25());
  music.efchan.push(new ef_26());
  music.efchan.push(new ef_27());
  music.efchan.push(new ef_28());
  music.efchan.push(new ef_29());
  music.efchan.push(new ef_30());
  music.efchan.push(new ef_31());
  music.efchan.push(new ef_32());
  music.efchan.push(new ef_33());
  music.efchan.push(new ef_34());
  music.efchan.push(new ef_35());
	music.addeffect("bag_mode_enter"); 					// *
	music.addeffect("cannot_place_item", 0.1); 			// Not used 
	music.addeffect("cannot_place_item_2", 0.1); 		// *
	music.addeffect("carbeep"); 								// *
	music.addeffect("cat_put_in_bag");					// Not used
	music.addeffect("cat_put_in_bin");					// TO DO
	music.addeffect("catgoodbye");							// *
	music.addeffect("catlick");									// TO DO
	music.addeffect("catmeow1");								// *
	music.addeffect("catmeow2");								// *
	music.addeffect("catpickup");								// *
	music.addeffect("catpickup2");							// *
	music.addeffect("catpurr", 0.5);						// *
	music.addeffect("close_bag");								// *
	music.addeffect("close_cage");							// *
	music.addeffect("doorknock");								// *
	music.addeffect("dooropen");								// *
	music.addeffect("drop_item_in_bag", 0.1);				// *
	music.addeffect("drop_item_in_bin", 0.1);				// *
	music.addeffect("drop_item_in_bin_2", 0.1);			// *
	music.addeffect("pistol");									// *
	music.addeffect("floorboardsqueak_1");			// TO DO
	music.addeffect("floorboardsqueak_2");			// TO DO
	music.addeffect("sadcat1");									// TO DO
	music.addeffect("sadcat2");									// TO DO
	music.addeffect("take_item_from_bag", 0.1);			// *
	music.addeffect("take_item_from_floor", 0.1);		// *
	music.addeffect("text_window_changes", 0.1);// *
	music.addeffect("text_window_closes");			// TO DO
	music.addeffect("text_window_opens");				// *
	music.addeffect("title_select");						// *
	music.addeffect("title_selection_change");	// TO DO
	music.addeffect("traffic1");								// *
	music.addeffect("traffic2");								// *
	music.addeffect("traffic3");								// *
	music.addeffect("doorclose");								// *

	var tempbmp:Bitmap;
	//Load Tiles, Sprites
	tempbmp = new im_tiles();	gfx.buffer = tempbmp.bitmapData;	gfx.maketilearray();
	
	gfx.makespritearray();
	
	//Load large images
	tempbmp = new im_image0();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image1();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image2();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image3();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image4();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image5();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	
	tempbmp = new im_image6();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image7();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image8();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image9();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image10();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image11();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
	tempbmp = new im_image12();	gfx.buffer = tempbmp.bitmapData;	gfx.addimage(); // 0
}

public function init():void {
	game.gamestate = def.TITLEMODE;
	game.gamestate = def.CLICKTOSTART;
	
	//Init all entity types
	obj.templates.push(new ent_player());
	obj.templates.push(new ent_otherperson());
	obj.loadtemplates();
}