﻿import com.terry.engine.*;
import gamecontrol.*;
import config.*;

public function titleinput():void {
	if (mouse.justleftpressed() && !game.jumpheld && gfx.fademode==def.FADED_IN) {
		gfx.fademode = def.FADE_OUT;
		gfx.fadeaction = def.FADEACTION_INTRO;
		control.start(0);
		game.keyheld = true;
		music.playef("title_select");
  }
	
	if (key.justPressed("R")) {
		control.playcount = 0;
		control.reset();
		control.creditsorder = 0;
		control.itemmessage = "Play count reset!";
		control.itemmessagetime = 180;
	}
}

public function gameoverinput():void {
	if (mouse.justleftpressed() && !game.jumpheld && gfx.fademode==def.FADED_IN) {
		gfx.fademode = def.FADE_OUT;
		gfx.fadeaction = def.FADEACTION_TITLE;
		game.keyheld = true;
  }
}

public function trashinput():void {
	if (game.running) {
		if (game.pausescript) {
			//Advance text
			if (game.press_action && !game.keyheld) {
				game.pausescript = false;
				textbox.textboxremove();
				
				game.keyheld = true;
			}
		}
	}
}

public function walkaboutgameinput():void {
	var i:int = obj.getplayer();
	
	if (game.running) {
		if (game.pausescript) {
			//Advance text
			if (game.press_action && !game.keyheld) {
				game.pausescript = false;
				textbox.textboxremove();
				
				game.keyheld = true;
			}
		}
		
		for (i = 0; i < obj.nentity; i++) {
			if (obj.entities[i].doscriptmove) {
				if (obj.entities[i].scriptmovedestx > obj.entities[i].xp + 2) {
					obj.entities[i].vx = 1;
				}else if (obj.entities[i].scriptmovedestx < obj.entities[i].xp - 2) {
					obj.entities[i].vx = -1;
				}else {
					obj.entities[i].vx = 0;
				}
				
				if (obj.entities[i].scriptmovedesty > obj.entities[i].yp + 2) {
					obj.entities[i].vy = 1;
				}else if (obj.entities[i].scriptmovedesty < obj.entities[i].yp - 2) {
					obj.entities[i].vy = -1;
				}else {
					obj.entities[i].vy = 0;
				}
				
				if (control.carryingsuitcase) {
					obj.entities[i].vx = obj.entities[i].vx/2;
					obj.entities[i].vy = obj.entities[i].vy/2;
				}
				
				if (obj.entities[i].vy == 0 && obj.entities[i].vx == 0) {
					obj.entities[i].doscriptmove = false;
				}
			}
		}
	}else{
		if (mouse.leftpressed()) {
			if(!game.keyheld){
				game.keyheld = true;
				
				//If point is ok
				control.destinationaction = "null";
				control.destset = true;
				control.xdest = (mouse.x / 2) - 8;
				control.ydest = (mouse.y / 2) - 8;
				control.lastxpos = obj.entities[i].xp + 1;
				control.lastxpos2 = obj.entities[i].xp + 2;
				control.lastypos = obj.entities[i].yp + 1;
				control.lastypos2 = obj.entities[i].yp + 2;
			}
		}else {
			game.keyheld = false;
		}
		
		if (control.destset) {
			if (control.xdest > obj.entities[i].xp + 2) {
				game.press_right = true;
			}else if (control.xdest < obj.entities[i].xp - 2) {
				game.press_left = true;
			}
			
			if (control.ydest > obj.entities[i].yp + 2) {
				game.press_down = true;
			}else if (control.ydest < obj.entities[i].yp - 2) {
				game.press_up = true;
			}
			
			if (control.carryingtrash) {
				if (game.press_left) {
					obj.entities[i].vx = -0.75;
				}else if (game.press_right) {
					obj.entities[i].vx = 0.75;
				}else {
					obj.entities[i].vx = 0;
				}
				
				if (game.press_up) {
					obj.entities[i].vy = -0.75;
				}else if (game.press_down) {
					obj.entities[i].vy = 0.75;
				}else {
					obj.entities[i].vy = 0;
				}
			}else{
				if (game.press_left) {
					obj.entities[i].vx = -1;
				}else if (game.press_right) {
					obj.entities[i].vx = 1;
				}else {
					obj.entities[i].vx = 0;
				}
				
				if (game.press_up) {
					obj.entities[i].vy = -1;
				}else if (game.press_down) {
					obj.entities[i].vy = 1;
				}else {
					obj.entities[i].vy = 0;
				}
			}
		}
	}
}

public function gameinput():void {
	var i:int;
	control.readytoclick = false;
	
	//Entity type 0 is player controled
	if (game.running) {
		if (game.pausescript) {
			//Advance text
			if (game.press_action && !game.keyheld) {
				game.pausescript = false;
				textbox.textboxremove();
				
				game.keyheld = true;
			}
		}
	}else{
		if(control.gamephase==control.GAMEPHASE_PACKING || control.gamephase == control.GAMEPHASE_CATPACKING){
			if (mouse.leftpressed()) {
				game.keyheld = true;
				if (control.currentitem == "nothing") {
					if (control.highlighted != "nothing") {
						if (control.gamephase == control.GAMEPHASE_CATPACKING) {
							control.currentitem = control.highlighted;
							if (control.currentitem == "nothing"  || control.currentitem == "cat") {
							  i = control.itemindex[control.currentitem];
								control.itemoffset.setTo((mouse.x / 2) - control.items[i].position.x, (mouse.y / 2) - control.items[i].position.y);
								if (control.currentitem == "cat") {
									music.playef("catpickup");
									control.catstate = "pickedup";
									control.catframe = 0;
									control.catframedelay = 0;
								}else {
									if (control.items[i].insuitcase) {
										music.playef("take_item_from_bag");
									}else{
										music.playef("take_item_from_floor");
									}
								}
								
								if (control.items[i].insuitcase) {
									control.items[i].insuitcase = false;
									control.getxpos(i);
									control.getypos(i);
									control.removesuitcaseitem(control.xpos, control.ypos, control.items[i].size.x, control.items[i].size.y);
								} 
							}else {
								control.currentitem = "nothing";
							}
						}else {
							control.currentitem = control.highlighted;
							i = control.itemindex[control.currentitem];
							control.itemoffset.setTo((mouse.x / 2) - control.items[i].position.x, (mouse.y / 2) - control.items[i].position.y);
							if (control.currentitem == "cat") {
								music.playef("catpickup");
								control.catstate = "pickedup";
								control.catframe = 0;
								control.catframedelay = 0;
							}else {
								if (control.items[i].insuitcase) {
									music.playef("take_item_from_bag");
								}else{
									music.playef("take_item_from_floor");
								}
							}
							
							if (control.items[i].insuitcase) {
								control.items[i].insuitcase = false;
								control.getxpos(i);
								control.getypos(i);
								control.removesuitcaseitem(control.xpos, control.ypos, control.items[i].size.x, control.items[i].size.y);
							}
						}
					}else {
						if(control.gamephase == control.GAMEPHASE_PACKING){
							if ((mouse.x / 2 > 308) && (mouse.y * 2) < 83) {
								if (control.gotpassport()) {
									control.readytoclick = true;
									control.gamephase++;
									control.gamephasestate = 0; control.gamephasedelay = 0;
									if(!game.running){
										game.load("finishedpacking");
									}
								}else if (control.dildo_ukelele() || control.dildo_teddy() || control.spycase()) {
									control.readytoclick = true;
									control.gamephase++;
									control.gamephasestate = 0; control.gamephasedelay = 0;
									if(!game.running){
										game.load("finishedpacking");
									}
								}else {
									if(!game.running){
										game.load("nopassport");
										game.keyheld = true;
									}
								}
							}
						}
					}
				}else {
					//Move the object under the cursor
					control.items[control.itemindex[control.currentitem]].position.setTo((mouse.x / 2) - control.itemoffset.x, (mouse.y / 2) - control.itemoffset.y);
					
					if (control.items[control.itemindex[control.currentitem]].placedinsuitcase) {
						//We're moving around an item that had previously been in the suitcase:
						//If it leaves the suitcase bounds, chuck it out.
						var testvar:int = 0;
						var item:int = control.itemindex[control.currentitem];
						if (control.items[item].position.x + (control.items[item].size.x * def.TILESIZE) >= (def.SCREENWIDTH / 2) - (4 * def.TILESIZE)) {
							if (control.items[item].position.y + (control.items[item].size.y * def.TILESIZE) >= (def.SCREENHEIGHT / 2) - (5 * def.TILESIZE)) {
								if (control.items[item].position.x < (def.SCREENWIDTH / 2) + (4 * def.TILESIZE)) {
									if (control.items[item].position.y < (def.SCREENHEIGHT / 2) + (5 * def.TILESIZE)) {
										testvar = 1;
									}
								}
							}
						}
						
						if (testvar == 0) {
							if (control.items[item].cannotbin) {
								control.items[item].returntoinitposition = true;
								control.items[item].placedinsuitcase = false;
								control.currentitem = "nothing";
								control.highlighted = "nothing";
							}else {
								if (control.autobinning) {
									control.items[item].binit = true;
									control.currentitem = "nothing";
									control.highlighted = "nothing";
								}
							}
						}
					}
				}
			}else {
				game.keyheld = false;
				control.highlighted = control.gethighlighted();
				if (control.currentitem == "cat") {
					//Special, released cat
					if (control.gamephase == control.GAMEPHASE_CATPACKING) {
						item = control.itemindex[control.currentitem];
						control.getxpos(item);
						control.getypos(item);
						if (control.xpos == 0 && control.ypos == 0) {
							control.gamephase = control.GAMEPHASE_CATPACKED;
						  control.gamephasestate = 0; control.gamephasedelay = 0;
							music.playef("catmeow2");
						}else {
							control.catstate = "bothered1";
							control.catstatedelay = 90;
						}
					}else{
						control.catstate = "bothered1";
						control.catstatedelay = 90;
						
						music.playef("catpickup2");
					}
				}else if (control.currentitem != "nothing") {
					//Just released an item - was it over the suitcase?
					item = control.itemindex[control.currentitem];
					control.getxpos(item);
					control.getypos(item);
					//Tests:
					// - Does it fit in the suitcase?
					// - Does the proposed position collide with any items?
					// - If not, set it as placed in the suitcase. 
					
					//Before we do anything: check if we're even in the suitcase range.
					//We want to be able to move stuff around the suitcase without losing it altogether!
					if (control.items[item].position.x + (control.items[item].size.x * def.TILESIZE) >= (def.SCREENWIDTH / 2) - (4 * def.TILESIZE)) {
						if (control.items[item].position.y + (control.items[item].size.y * def.TILESIZE) >= (def.SCREENHEIGHT / 2) - (5 * def.TILESIZE)) {
							if (control.items[item].position.x < (def.SCREENWIDTH / 2) + (4 * def.TILESIZE)) {
								if (control.items[item].position.y < (def.SCREENHEIGHT / 2) + (5 * def.TILESIZE)) {
									//Cool!
									testvar = 0;
									if (control.xpos >= 0 && control.ypos >= 0) {
										if (control.xpos < 6 && control.ypos < 6) {
											if (control.xpos + control.items[item].size.x <= 6) {
												if (control.ypos + control.items[item].size.y <= 6) {
													//It fits! Does it collide?
													for (var j:int = control.ypos; j < control.ypos + control.items[item].size.y; j++) {
														for (i = control.xpos; i < control.xpos + control.items[item].size.x; i++) {
															if (i >= 0 && i < 6 && j >= 0 && j < 6) {
																if (control.suitcase[i + (j * 6)] == 1) {
																	testvar = 1;
																}
															}
														}
													}
													
													if (testvar == 0) {							
														music.playef("drop_item_in_bag");
														control.items[item].insuitcase = true;
														control.fillsuitcase(control.xpos, control.ypos, control.items[item].size.x, control.items[item].size.y);
														if (control.gamephase == control.GAMEPHASE_CATPACKING) {
															control.items[item].position.x = (control.xpos * def.TILESIZE) + control.catcagexpos;
															control.items[item].position.y = (control.ypos * def.TILESIZE) + control.catcageypos;
														}else{
															control.items[item].position.x = (control.xpos * def.TILESIZE) + control.suitcasexpos;
															control.items[item].position.y = (control.ypos * def.TILESIZE) + control.suitcaseypos;
														}
														control.items[item].placedinsuitcase = true;
													}else {
														control.items[item].returntoinitposition = true;
													}
												}else {
													control.items[item].returntoinitposition = true;
												}
											}else {
												control.items[item].returntoinitposition = true;
											}
										}else {
											control.items[item].returntoinitposition = true;
										}
									}else {
										control.items[item].returntoinitposition = true;
									}
								}
							}
						}
					}
					
					//Check we're not outside screen boundaries
					if (control.items[item].position.x + (control.items[item].size.x * def.TILESIZE) > def.SCREENWIDTH) {
						control.items[item].returntoinitposition = true;
					}
					if (control.items[item].position.y + (control.items[item].size.y * def.TILESIZE) > def.SCREENHEIGHT) {
						control.items[item].returntoinitposition = true;
					}
					if (control.items[item].position.x < 0 ) {
						control.items[item].returntoinitposition = true;
					}
					if (control.items[item].position.y < 0) {
						control.items[item].returntoinitposition = true;
					}
					
					if (control.items[item].position.x > 308 && control.items[item].position.y < 83) {
						control.items[item].returntoinitposition = true;
					}
					
					if (control.items[item].returntoinitposition) {
						music.playef("cannot_place_item_2");
					}
					
					//How about over the bin?
					if (control.items[item].position.x  + (control.items[item].size.x * def.TILESIZE) >= def.SCREENWIDTH - (3 * def.TILESIZE) - 8) {
						if (control.items[item].position.y + (control.items[item].size.y * def.TILESIZE) >= def.SCREENHEIGHT - (4 * def.TILESIZE) - 8) {
							if (control.items[item].cannotbin) {
								control.items[item].returntoinitposition = true;
								control.items[item].placedinsuitcase = false;
								control.items[item].binit = false;
							}else{
								control.bintile = control.items[item].bintile;
								control.items[item].usedingame = false;
								control.items[item].trashed = true;
								
								music.playef("drop_item_in_bin");
							}
						}
					}
					
				}
				control.currentitem = "nothing";
				
				if ((mouse.x / 2 > 308) && (mouse.y * 2) < 83) {
					control.readytoclick = true;
				}
			}
		}
	}
	
	/*
	if (key.justPressed("F1") && !key.keyheld["F1"]) {
		trace("OUTPUTTING OBJECT POSITION INFORMATION");
		for (i = 0; i < control.numitems; i++) {
			if (i == 0) {
				trace("if (t == \"" + control.items[i].name + "\"){");
			}else{
				trace("}else if (t == \"" + control.items[i].name + "\"){");
			}
			trace("  position.setTo(" + String(control.items[i].position.x) + ", " + String(control.items[i].position.y) + ");");
			trace("  size.setTo(" + String(control.items[i].size.x) + ", " + String(control.items[i].size.y) + ");");
			trace("  tile = " + String(control.items[i].tile) + ";");
			trace("  minisize.setTo(" + String(control.items[i].minisize.x) + ", " + String(control.items[i].minisize.y) + ");");
			trace("  minitile = " + String(control.items[i].minitile) + ";");
		}
		trace("}");
		
		key.keyheld["F1"] = true;
	}
	*/
}
