﻿import com.terry.engine.*;
import gamecontrol.*;
import config.*;

public function titlelogic():void {
	if (control.itemmessagetime > 0) control.itemmessagetime--;
	control.fadelogic();
}

public function walkaboutgamelogic():void {
	var i:int = 0;

	if (map.levelimg != -1 && map.levelimg < 2) {
		control.updatecar();
	}
	
	control.showactionmessagetime--;
	if(control.showactionmessagetime < 0) control.showactionmessagetime = 0;
	//Update entities
	if (!game.completestop) {
		obj.updateparticles();          // Update particles
		
		for (i = 0; i < obj.nentity;  i++) {
			obj.updateentities(i);          // Behavioral logic
			obj.updateentitylogic(i);       // Basic Physics
			obj.entitymapcollision(i);      // Collisions with walls
		}
		
		obj.entitycollisioncheck();       // Check ent v ent collisions, update states
	}
	
	//Run scripts if the player stops moving
	if (!game.running && gfx.fademode == def.FADED_IN && control.destset) {
		i = obj.getplayer();
		if (control.destinationaction != "null") {
			if (control.destinationaction == control.suitcasename) {
				if (Math.sqrt(Math.abs(gfx.screenwidthmid - obj.entities[i].xp) * Math.abs(gfx.screenwidthmid - obj.entities[i].xp)	+ Math.abs(gfx.screenheightmid +32 - obj.entities[i].yp) * Math.abs(gfx.screenheightmid + 32 - obj.entities[i].yp)) <= 28) {
					game.load(control.destinationaction);
					control.destset = false;
					control.xdest = obj.entities[i].xp;	control.ydest = obj.entities[i].yp;
					obj.entities[i].vx = 0;	obj.entities[i].vy = 0;
					
					game.keyheld = true;
				}
			}else{
				if (obj.entities[i].vx == 0 && obj.entities[i].vy == 0) {
					game.load(control.destinationaction);
					control.destset = false;
					control.xdest = obj.entities[i].xp;	control.ydest = obj.entities[i].yp;
					obj.entities[i].vx = 0;	obj.entities[i].vy = 0;
					
					game.keyheld = true;
				}
			}
		}
	}else {
		control.destinationaction = "null";
	}
	
	//Camera code and room changes
	map.cameracontrol();
	control.fadelogic();
}

public function gameoverlogic():void {
	control.fadelogic();
}

public function trashlogic():void {
	control.updatestars();
	control.fadelogic();
}

public function gamelogic():void {
	var i:int = 0, j:int = 0;
	
	if (control.gamephase == control.GAMEPHASE_CATPACKED) {
		if (control.gamephasestate == 0) {
			//Cat is confused
			control.gamephasedelay++;
			if (control.gamephasedelay >= 90) {
				music.playef("close_cage");
				control.gamephasestate++;
				control.gamephasedelay = 0;
			}
		}else if (control.gamephasestate == 1) {
			//Cat is locked up!
			control.gamephasedelay++;
			if (control.gamephasedelay >= 120) {
				control.gamephasestate++;
				control.gamephasedelay = 0;
			}
		}else if (control.gamephasestate == 2) {
			//Move on with game
			control.gamephasestate++;
			control.suitcasepacked = true;
			control.catpacked = true;
			gfx.fademode = def.FADE_OUT;
			gfx.fadeaction = def.FADEACTION_AFTERPACKING;
		}
	}else if (control.gamephase == control.GAMEPHASE_PACKING) {
		control.updatetime();
		control.moveitems();
		control.updatecat();
	}else if (control.gamephase == control.GAMEPHASE_CATPACKING) {
		control.updatecat();
		
		if (control.gamephasestate == 0) {
			//Bin everything!
			for (i = 0; i < control.numitems; i++) {
				if (!control.items[i].insuitcase) {
					if (control.items[i].name != "cat" && control.items[i].name != "sunflower") {
						control.items[i].binit = true;
					}
				}
			}
			control.gamephasestate++;
		}else if (control.gamephasestate == 1) {
			j = 0;
			control.buttonpos -= 2;
			for (i = 0; i < control.numitems; i++) {
				if (control.items[i].usedingame) {
					if (control.items[i].binit) {
						j++;
						if (control.items[i].position.x < def.SCREENWIDTH - (3 * def.TILESIZE)) {
							control.items[i].position.x += 16;
						}
						
						if (control.items[i].position.y < def.SCREENHEIGHT - (4 * def.TILESIZE)) {
							control.items[i].position.y += 10;
						}
						
						if (control.items[i].position.x >= def.SCREENWIDTH - (4 * def.TILESIZE) &&
								control.items[i].position.y >= def.SCREENHEIGHT - (5 * def.TILESIZE)) {
							control.bintile = control.items[i].bintile;
							control.items[i].usedingame = false;
							control.items[i].trashed = true;
							control.items[i].binit = false;
						}
					}
				}
			}
			
			if (j == 0 && control.buttonpos<=-100) {
				control.gamephasestate++;
			}
		}
	}else if (control.gamephase == control.GAMEPHASE_ENDPACKING) {
		control.updatecat();
		
		if (control.gamephasestate == 0) {
			//Bin everything!
			var arewebinningsomething:Boolean = false;
			for (i = 0; i < control.numitems; i++) {
				if (!control.items[i].insuitcase) {
					if (control.items[i].name != "cat" && control.items[i].name != "sunflower") {
						control.items[i].binit = true;
						arewebinningsomething = true;
					}
				}
			}
			if (arewebinningsomething) music.playef("drop_item_in_bin_2");
			control.gamephasestate++;
		}else if (control.gamephasestate == 1) {
			j = 0;
			control.buttonpos -= 2;
			for (i = 0; i < control.numitems; i++) {
				if (control.items[i].usedingame) {
					if (control.items[i].binit) {
						j++;
						if (control.items[i].position.x < def.SCREENWIDTH - (3 * def.TILESIZE)) {
							control.items[i].position.x += 16;
						}
						
						if (control.items[i].position.y < def.SCREENHEIGHT - (4 * def.TILESIZE)) {
							control.items[i].position.y += 10;
						}
						
						if (control.items[i].position.x >= def.SCREENWIDTH - (4 * def.TILESIZE) &&
								control.items[i].position.y >= def.SCREENHEIGHT - (5 * def.TILESIZE)) {
							control.bintile = control.items[i].bintile;
							control.items[i].usedingame = false;
							control.items[i].trashed = true;
							control.items[i].binit = false;
						}
					}
				}
			}
			
			if (j == 0 && control.buttonpos<=-100) {
				control.gamephasestate++;
			}
		}
	}
	
	//Camera code and room changes
	map.cameracontrol();
	control.fadelogic();
}