﻿import com.terry.engine.*;
import gamecontrol.*;
import config.*;

public function titlerender():void {
	if (control.playcount % 3 == 1) {
		gfx.drawimage(3, 0, 0);
		if (control.creditsorder == 0) {
			gfx.print(5, 215, "by Stephen Lavelle and Terry Cavanagh", 71, 145, 244, true);
		}else {
			gfx.print(5, 215, "by Terry Cavanagh and Stephen Lavelle", 71, 145, 244, true);
		}
	}else if (control.playcount % 3 == 2) {
		gfx.drawimage(4, 0, 0);
		if (control.creditsorder == 0) {
			gfx.print(5, 215, "by Stephen Lavelle and Terry Cavanagh", 102, 244, 71, true);
		}else {
			gfx.print(5, 215, "by Terry Cavanagh and Stephen Lavelle", 102, 244, 71, true);
		}
	}else if (control.playcount % 3 == 0) {
		gfx.drawimage(5, 0, 0);
		if (control.creditsorder == 0) {
			gfx.print(5, 215, "by Stephen Lavelle and Terry Cavanagh", 244, 71, 76, true);
		}else {
			gfx.print(5, 215, "by Terry Cavanagh and Stephen Lavelle", 244, 71, 76, true);
		}
	}
	
	if (control.itemmessagetime > 0) {
		var buttonpos:int;
		if (control.itemmessagetime > 20) {
			buttonpos = 0;
		}else {
			buttonpos = -(20-control.itemmessagetime);
		}
		gfx.fillrect(gfx.screenwidth-(gfx.len(control.itemmessage)+12), 0 + buttonpos, gfx.len(control.itemmessage)+12+2, 19, 0, 0, 0);
		gfx.fillrect(gfx.screenwidth-(gfx.len(control.itemmessage)+12) + 2, 0 + buttonpos, gfx.len(control.itemmessage)+12, 17, 126, 0, 44);
		
		gfx.print(gfx.screenwidth-(gfx.len(control.itemmessage)+12) + 6, 1 + buttonpos, control.itemmessage, 255, 255, 255);
	}
	
}

public function gameoverrender():void {	
	gfx.bigprint(0, gfx.screenheightmid-10, "GAME OVER", 196, 196, 196, true);
}

public function walkaboutgamerender():void {
	for (var j:int = 0; j < 20; j++) {
		for (var i:int = 0; i < 25; i++) {
			gfx.drawtile(i * 16, j * 16, 481);
		}
	}
	
	if(map.levelimg==-1){
		draw.drawmap();
	}else {
		gfx.drawimage(map.levelimg, 0, 0);
		
		if(map.levelimg < 2){
			gfx.drawimage(6 + control.cartype, gfx.screenwidth - (control.carposition * 7), gfx.screenheight - 70 + int(help.glow / 6));
		}
		
		if (help.inboxw(mouse.x / 2, mouse.y / 2, (8 * 16)-8, 2 * 16, 3*16, 5 * 16)) {
			control.showactionmessage(control.dumpstername);
			if (help.slowsine % 32 > 16) {
				draw.drawtilegrid(8 * 16, 2 * 16, 0, 30, 3, 5);	
			}
		}
		
		if (help.inboxw(mouse.x / 2, mouse.y / 2, (18 * 16)-8, 1 * 16, 3*16, 5 * 16)) {
			control.showactionmessage(control.flatname);
			if (help.slowsine % 32 > 16) {
				draw.drawtilegrid((18 * 16)-2, (1 * 16)+12, 3, 30, 3, 4);	
			}
		}
	}
	
	if (map.levelimg==-1){
		draw.miniluggage();
	}else {
		
	}
	
	gfx.drawentities();
	draw.drawparticles();
	
	gfx.drawgui();
	
	if (control.showactionmessagetime > 0) {
		gfx.fillrect(gfx.screenwidth-gfx.len(control.actionmessage)-17, -23 + control.showactionmessagetime, 83+50, 19, 0, 0, 0);
		gfx.fillrect(gfx.screenwidth-gfx.len(control.actionmessage)-15, -23 + control.showactionmessagetime, 81+50, 17, 126, 0, 44);
		gfx.print(gfx.screenwidth-gfx.len(control.actionmessage)-8, -20 + control.showactionmessagetime, control.actionmessage, 255, 255, 255);
	}
}

public function trashrender():void {	
	var t:int;
	gfx.fillrect(0, 0, gfx.screenwidth, gfx.screenheight, 255, 169, 229);
	
	t = control.numitems + 1;
	gfx.drawsprite( -32 + control.starposition1 + control.gettransx(t), control.starpositiony1, t, control.starrotation, control.gettransx(t), control.gettransy(t));
	gfx.drawsprite( -32 + control.starposition2 + control.gettransx(t), control.starpositiony2, t, -control.starrotation, control.gettransx(t), control.gettransy(t));
	gfx.drawsprite( -32 + control.starposition3 + control.gettransx(t), control.starpositiony3, t, control.starrotation, control.gettransx(t), control.gettransy(t));
	gfx.drawsprite( -32 + control.starposition4 + control.gettransx(t), control.starpositiony4, t, -control.starrotation, control.gettransx(t), control.gettransy(t));
	gfx.drawsprite( -32 + control.starposition5 + control.gettransx(t), control.starpositiony5, t, control.starrotation, control.gettransx(t), control.gettransy(t));
  
	gfx.drawsprite( -32 + gfx.screenwidth - control.starposition1 + control.gettransx(t), gfx.screenheight - 32 - control.starpositiony1, t, control.starrotation, control.gettransx(t), control.gettransy(t));
	gfx.drawsprite( -32 + gfx.screenwidth - control.starposition2 + control.gettransx(t), gfx.screenheight - 32 - control.starpositiony2, t, -control.starrotation, control.gettransx(t), control.gettransy(t));
	gfx.drawsprite( -32 + gfx.screenwidth - control.starposition3 + control.gettransx(t), gfx.screenheight - 32 - control.starpositiony3, t, control.starrotation, control.gettransx(t), control.gettransy(t));
	gfx.drawsprite( -32 + gfx.screenwidth - control.starposition4 + control.gettransx(t), gfx.screenheight - 32 - control.starpositiony4, t, -control.starrotation, control.gettransx(t), control.gettransy(t));
	gfx.drawsprite( -32 + gfx.screenwidth - control.starposition5 + control.gettransx(t), gfx.screenheight - 32 - control.starpositiony5, t, control.starrotation, control.gettransx(t), control.gettransy(t));
	
	t = control.previoustrash;
	if (t > -1) {
		if (control.items[t].name == "chocolate" && control.outcome == control.BREAKING_UP) {
			gfx.drawsprite(gfx.screenwidthmid - control.gettransx(t) + ((gfx.screenheight - control.trashlerp)*2), gfx.screenheightmid - control.gettransy(t), t, control.trashrotation, control.gettransx(t), control.gettransy(t));
		}else{
			gfx.drawsprite(gfx.screenwidthmid - control.gettransx(t), gfx.screenheightmid - control.gettransy(t) + (gfx.screenheight - control.trashlerp), t, control.trashrotation, control.gettransx(t), control.gettransy(t));
		}
	}
	t = control.nexttrash;
	if (t == control.numitems) {
		gfx.drawsprite(gfx.screenwidthmid - control.gettransx(t), gfx.screenheight + control.gettransy(t) - (control.trashlerp*2), t, control.trashrotation, control.gettransx(t), control.gettransy(t));
	}else{
		if (t > -1) {
			gfx.drawsprite(gfx.screenwidthmid - control.gettransx(t), gfx.screenheightmid - control.gettransy(t) - control.trashlerp, t, control.trashrotation, control.gettransx(t), control.gettransy(t));
		}
	}
	
	if (control.nexttrash > -1 && control.nexttrash < control.numitems) {
		if (control.outcome == control.SPY) {
			draw.bigborderprint(4, gfx.screenheight - gfx.hig("a", 2) - 5, "Spy " + control.items[control.nexttrash].printedname, 255, 255, 255);
		}else{
			draw.bigborderprint(4, gfx.screenheight - gfx.hig("a", 2) - 5, control.items[control.nexttrash].printedname, 255, 255, 255);
		}
	}
	
	gfx.drawgui();
}

public function gamerender():void {	
	var i:int, j:int, item:int;
	draw.drawbackground();
	
	//Draw suitcase
	if (control.gamephase == control.GAMEPHASE_CATPACKED) {
		if (control.gamephasestate == 0) {
			//Cat is confused
			draw.drawtilegrid((def.SCREENWIDTH / 2) - ((3 * def.TILESIZE) / 2), (def.SCREENHEIGHT / 2) - ((3 * def.TILESIZE) / 2), 2, 14, 3, 3);
		}else {
			draw.drawtilegrid((def.SCREENWIDTH / 2) - ((3 * def.TILESIZE) / 2), (def.SCREENHEIGHT / 2) - ((3 * def.TILESIZE) / 2), 5, 14, 3, 3);
		}
		
		for (j = 0; j < 2; j++) {
			for (i = 0; i < 2; i++) {
				if (control.suitcase[i + (j * 6)] == 1) {
					gfx.drawtile(control.catcagexpos + (i * def.TILESIZE), control.catcageypos + (j * def.TILESIZE), 230);	
				}
			}
		}
		
		//Draw catbed
		draw.drawtilegrid(9, 207, 10, 9, 2, 2);
		
		control.highlighttext = "nothing";
		mouse.holdingcat = false;
	}else if (control.gamephase == control.GAMEPHASE_CATPACKING) {
		draw.drawtilegrid((def.SCREENWIDTH / 2) - ((3 * def.TILESIZE) / 2), (def.SCREENHEIGHT / 2) - ((3 * def.TILESIZE) / 2), 2, 11, 3, 3);
		
		for (j = 0; j < 2; j++) {
			for (i = 0; i < 2; i++) {
				if (control.suitcase[i + (j * 6)] == 1) {
					gfx.drawtile(control.catcagexpos + (i * def.TILESIZE), control.catcageypos + (j * def.TILESIZE), 230);	
				}
			}
		}
		
		//Draw highlight squares in suitcase for moving objects
		if (control.currentitem != "nothing") {
			item = control.itemindex[control.currentitem];
			
			control.getxpos(item);
			control.getypos(item);
			
			if (control.xpos >= -2 && control.xpos < 2) {
				if (control.ypos >= -2 && control.ypos < 2) {
					for (j = control.ypos; j < control.ypos + control.items[item].size.y; j++) {
						for (i = control.xpos; i < control.xpos + control.items[item].size.x; i++) {
							if (i >= 0 && i < 2 && j >= 0 && j < 2) {
								if (control.suitcase[i + (j * 6)] == 0) {
									gfx.drawtile(control.catcagexpos + (i * def.TILESIZE), control.catcageypos + (j * def.TILESIZE), 248 + ((help.slowsine % 32) / 8));	
								}else {
									gfx.drawtile(control.catcagexpos + (i * def.TILESIZE), control.catcageypos + (j * def.TILESIZE), 231);	
								}
							}
						}
					}
				}
			}
		}
		
		//Draw catbed
		draw.drawtilegrid(9, 207, 10, 9, 2, 2);
		
		control.highlighttext = "nothing";
		mouse.holdingcat = false;
		
		i = control.itemindex["cat"];
		if (control.items[i].usedingame) {
			if (control.showborders) {
				if (control.items[i].insuitcase && control.currentitem != control.itemindex[i]) {
					draw.smallborder(i);
				}
			}
			
			if (control.items[i].highlight) {
				draw.highlightborder(i);
			}
			
			if (control.highlighted == control.items[i].name) {
				//Draw cool border around it
				draw.drawborder(i);
			}
			
			if (control.items[i].iscat) {
				//Cat is special!
				if (control.currentitem == "cat") {
					//We're holding the cat: don't draw it here
				}else {
					draw.cat(i);
				}
			}else {
				draw.drawtilegrid(control.items[i].position.x, control.items[i].position.y, control.items[i].tile, 0, control.items[i].size.x, control.items[i].size.y);	
			}
		}
	}else{
		draw.drawtilegrid((def.SCREENWIDTH / 2) - (4 * def.TILESIZE), (def.SCREENHEIGHT / 2) - (5 * def.TILESIZE), 12, 9, 8, 10);
		
		//Draw bin
		draw.drawtilegrid(def.SCREENWIDTH - (3 * def.TILESIZE), def.SCREENHEIGHT - (4 * def.TILESIZE), 8, 13, 2, 1);
		draw.drawtilegrid(def.SCREENWIDTH - (3 * def.TILESIZE), def.SCREENHEIGHT - (4 * def.TILESIZE), 10, 5, 2, 3);
		if (control.bintile > 0) {
			draw.drawtilegrid(def.SCREENWIDTH - (3 * def.TILESIZE), def.SCREENHEIGHT - (4 * def.TILESIZE), control.bintile, 0, 2, 1);
			draw.drawtilegrid(def.SCREENWIDTH - (3 * def.TILESIZE), def.SCREENHEIGHT - (4 * def.TILESIZE), 10, 5, 2, 1);
		}
		
		//Draw filled suitcase squares
		for (j = 0; j < 6; j++) {
			for (i = 0; i < 6; i++) {
				if (control.suitcase[i + (j * 6)] == 1) {
					gfx.drawtile(control.suitcasexpos + (i * def.TILESIZE), control.suitcaseypos + (j * def.TILESIZE), 230);	
				}
			}
		}
		
		//Draw highlight squares in suitcase for moving objects
		if (control.currentitem != "nothing") {
			item = control.itemindex[control.currentitem];
			
			control.getxpos(item);
			control.getypos(item);
			
			if (control.xpos >= -6 && control.xpos < 6) {
				if (control.ypos >= -6 && control.ypos < 6) {
					for (j = control.ypos; j < control.ypos + control.items[item].size.y; j++) {
						for (i = control.xpos; i < control.xpos + control.items[item].size.x; i++) {
							if (i >= 0 && i < 6 && j >= 0 && j < 6) {
								if (control.suitcase[i + (j * 6)] == 0) {
									gfx.drawtile(control.suitcasexpos + (i * def.TILESIZE), control.suitcaseypos + (j * def.TILESIZE), 248 + ((help.slowsine % 32) / 8));	
								}else {
									gfx.drawtile(control.suitcasexpos + (i * def.TILESIZE), control.suitcaseypos + (j * def.TILESIZE), 231);	
								}
							}
						}
					}
				}
			}
		}
			
		//Draw catbed
		draw.drawtilegrid(9, 207, 10, 9, 2, 2);
		
		control.highlighttext = "nothing";
		mouse.holdingcat = false;
		
		//Draw items
		for (i = control.numitems - 1; i >= 0; i--) {
			if (control.items[i].usedingame) {
				if (control.showborders) {
					if (control.items[i].insuitcase && control.currentitem != control.itemindex[i]) {
						draw.smallborder(i);
					}
				}
				
				if (control.items[i].highlight) {
					draw.highlightborder(i);
				}
				
				if (control.highlighted == control.items[i].name) {
					//Draw cool border around it
					draw.drawborder(i);
				}
				
				if (control.items[i].iscat) {
					//Cat is special!
					if (control.currentitem == "cat") {
						//We're holding the cat: don't draw it here
					}else {
						draw.cat(i);
					}
				}else {
					draw.drawtilegrid(control.items[i].position.x, control.items[i].position.y, control.items[i].tile, 0, control.items[i].size.x, control.items[i].size.y);	
				}
			}
		}
	}
	
	if (control.currentitem != "nothing") {
		i = control.itemindex[control.currentitem];
		
		if (control.gamephase == control.GAMEPHASE_PACKING) {
			if (control.items[i].position.x  + (control.items[i].size.x * def.TILESIZE) >= def.SCREENWIDTH - (3 * def.TILESIZE) - 8) {
				if (control.items[i].position.y + (control.items[i].size.y * def.TILESIZE) >= def.SCREENHEIGHT - (4 * def.TILESIZE) - 8) {
					draw.drawbinborder(i);
				}
			}
		}
		
		draw.drawborder(i);
		
		if (control.items[i].iscat) {
			//Cat is special!
			//We're holding the cat! Draw it squirming
			control.catstate = "pickedup";
			mouse.holdingcat = true;
			var temp:int = 64 + (control.catframe) * 2;
			draw.drawtilegrid(control.items[i].position.x, control.items[i].position.y, temp, 0, control.items[i].size.x, control.items[i].size.y);
		}else {
			draw.drawtilegrid(control.items[i].position.x, control.items[i].position.y, control.items[i].tile, 0, control.items[i].size.x, control.items[i].size.y);
		}
	}
	
	if (control.highlighttext != "nothing") {
		draw.borderprint(control.highlighttext_xp, control.highlighttext_yp, control.highlighttext, 255, 255, 255);
	}
	
	//draw.drawmap();
	//gfx.drawentities();
	//draw.drawparticles();
	
	gfx.drawgui();
	
	gfx.fillrect(301, 0 + control.buttonpos, 83, 19, 0, 0, 0);
	gfx.fillrect(303, 0 + control.buttonpos, 81, 17, 126, 0, 44);
	
	if(control.readytoclick){
		if(help.slowsine%16>8){
			draw.drawtilegrid(308, 2 + control.buttonpos, 0, 19, 3, 1);
		}else {
			draw.drawtilegrid(308, 2 + control.buttonpos, 0, 20, 3, 1);
		}
	}else {
		draw.drawtilegrid(308, 2 + control.buttonpos, 0, 19, 3, 1);
	}
	gfx.rprint(gfx.screenwidth - 8, 1 + control.buttonpos, control.getgametime(), 255, 255, 255);
	
	if (control.getmultihighlighted() != "nothing") {
		if (control.outcome == control.SPY) {
			draw.bigborderprint(4, gfx.screenheight - gfx.hig("a", 2) - 5, control.getspymultihighlighted(), 255, 255, 255);
		}else	if (gfx.len(control.getmultihighlighted()) > gfx.screenwidth) {
			draw.borderprint(4, gfx.screenheight - gfx.hig("a", 2) - 5, control.getmultihighlighted(), 255, 255, 255);
		}else{
			draw.bigborderprint(4, gfx.screenheight - gfx.hig("a", 2) - 5, control.getmultihighlighted(), 255, 255, 255);
		}
	}
}
